"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CombinedFieldsReadOnlyForm = CombinedFieldsReadOnlyForm;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _combined_field_label = require("./combined_field_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CombinedFieldsReadOnlyForm({
  combinedFields
}) {
  return combinedFields.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.dataVisualizer.combinedFieldsReadOnlyLabel', {
      defaultMessage: 'Combined fields'
    }),
    helpText: _i18n.i18n.translate('xpack.dataVisualizer.combinedFieldsReadOnlyHelpTextLabel', {
      defaultMessage: 'Edit combined fields in advanced tab'
    })
  }, /*#__PURE__*/_react.default.createElement("div", null, combinedFields.map((combinedField, idx) => /*#__PURE__*/_react.default.createElement(_combined_field_label.CombinedFieldLabel, {
    key: idx,
    combinedField: combinedField
  })))) : null;
}