"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const sourcePlaceholder = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.sourcePlaceholder', {
  defaultMessage: "field filter, accepts wildcards (e.g., `user*` to filter fields starting with 'user')"
});
const AddFilter = ({
  onAddFilter
}) => {
  const [filter, setFilter] = (0, _react.useState)('');
  const onAddButtonClick = (0, _react.useCallback)(() => {
    onAddFilter(filter);
    setFilter('');
  }, [filter, onAddFilter]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 10
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: filter,
    "data-test-subj": "fieldFilterInput",
    onChange: e => setFilter(e.target.value.trim()),
    placeholder: sourcePlaceholder
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "addFieldFilterButton",
    isDisabled: filter.length === 0,
    onClick: onAddButtonClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.editIndexPattern.source.addButtonLabel",
    defaultMessage: "Add"
  }))));
};
exports.AddFilter = AddFilter;