"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryToFields = queryToFields;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function queryToFields({
  dataView,
  sort,
  request
}) {
  let fields = dataView.timeFieldName ? [dataView.timeFieldName] : [];
  if (sort) {
    const sortArr = Array.isArray(sort) ? sort : [sort];
    fields.push(...sortArr.flatMap(s => Object.keys(s)));
  }
  for (const query of ((_request$query = request.query) !== null && _request$query !== void 0 ? _request$query : []).filter(_esQuery.isOfQueryType)) {
    var _request$query;
    if (query.query && query.language === 'kuery') {
      const nodes = (0, _esQuery.fromKueryExpression)(query.query);
      const queryFields = (0, _esQuery.getKqlFieldNames)(nodes);
      fields = fields.concat(queryFields);
    }
  }
  const {
    filters = []
  } = request;
  for (const f of typeof filters === 'function' ? filters() : filters) {
    var _f$meta;
    // unified search bar filters have meta object and key (regular filters)
    // unified search bar "custom" filters ("Edit as query DSL", where meta.key is not present but meta is)
    // Any other Elasticsearch query DSL filter that gets passed in by consumers (not coming from unified search, and these probably won't have a meta key at all)
    if ((0, _esQuery.isFilter)(f) && f !== null && f !== void 0 && (_f$meta = f.meta) !== null && _f$meta !== void 0 && _f$meta.key && f.meta.disabled !== true) {
      fields.push(f.meta.key);
    }
  }

  // if source filtering is enabled, we need to fetch all the fields
  const fieldName = dataView.getSourceFiltering() && dataView.getSourceFiltering().excludes.length ? ['*'] : fields;
  if (fieldName.length) {
    return (await dataView.getFields({
      fieldName
    })).getFieldMapSorted();
  }

  // no fields needed to be loaded for query
  return {};
}