"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateDashboardMeta = void 0;
var _telemetry_constants = require("../../../utils/telemetry_constants");
var _find_dashboards = require("./find_dashboards");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const updateDashboardMeta = async ({
  id,
  title,
  description = '',
  tags
}) => {
  const [dashboard] = await (0, _find_dashboards.findDashboardsByIds)([id]);
  if (dashboard.status === 'error') {
    return;
  }
  const savedObjectsTaggingApi = _kibana_services.savedObjectsTaggingService === null || _kibana_services.savedObjectsTaggingService === void 0 ? void 0 : _kibana_services.savedObjectsTaggingService.getTaggingApi();
  const references = savedObjectsTaggingApi !== null && savedObjectsTaggingApi !== void 0 && savedObjectsTaggingApi.ui.updateTagsReferences && tags.length ? savedObjectsTaggingApi.ui.updateTagsReferences(dashboard.references, tags) : dashboard.references;
  await _kibana_services.contentManagementService.client.update({
    contentTypeId: _telemetry_constants.DASHBOARD_CONTENT_ID,
    id,
    data: {
      title,
      description
    },
    options: {
      references
    }
  });
};
exports.updateDashboardMeta = updateDashboardMeta;