"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddTimeSliderControlButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _common = require("@kbn/controls-plugin/common");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
var _use_dashboard_api = require("../../../dashboard_api/use_dashboard_api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const AddTimeSliderControlButton = ({
  closePopover,
  controlGroupApi,
  ...rest
}) => {
  const [hasTimeSliderControl, setHasTimeSliderControl] = (0, _react.useState)(false);
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  (0, _react.useEffect)(() => {
    if (!controlGroupApi) {
      return;
    }
    const subscription = controlGroupApi.children$.subscribe(children => {
      const nextHasTimeSliderControl = Object.values(children).some(controlApi => {
        return (0, _presentationPublishing.apiHasType)(controlApi) && controlApi.type === _common.TIME_SLIDER_CONTROL;
      });
      setHasTimeSliderControl(nextHasTimeSliderControl);
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [controlGroupApi]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({}, rest, {
    icon: "timeslider",
    onClick: async () => {
      controlGroupApi === null || controlGroupApi === void 0 ? void 0 : controlGroupApi.addNewPanel({
        panelType: _common.TIME_SLIDER_CONTROL,
        initialState: {
          grow: true,
          width: 'large',
          id: (0, _uuid.v4)()
        }
      });
      dashboardApi.scrollToTop();
      closePopover();
    },
    "data-test-subj": "controls-create-timeslider-button",
    disabled: !controlGroupApi || hasTimeSliderControl,
    toolTipContent: hasTimeSliderControl ? (0, _dashboard_app_strings.getOnlyOneTimeSliderControlMsg)() : null
  }), (0, _dashboard_app_strings.getAddTimeSliderControlButtonTitle)());
};
exports.AddTimeSliderControlButton = AddTimeSliderControlButton;