"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navigateToVisEditor = navigateToVisEditor;
var _analytics = require("@kbn/analytics");
var _kibana_services = require("../../../services/kibana_services");
var _telemetry_constants = require("../../../utils/telemetry_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function navigateToVisEditor(api, visType) {
  var _api$getAppContext, _api$getAppContext2, _api$getAppContext2$g;
  let path = '';
  let appId = '';
  if (visType) {
    const trackUiMetric = _kibana_services.usageCollectionService === null || _kibana_services.usageCollectionService === void 0 ? void 0 : _kibana_services.usageCollectionService.reportUiCounter.bind(_kibana_services.usageCollectionService, _telemetry_constants.DASHBOARD_UI_METRIC_ID);
    if (trackUiMetric) {
      trackUiMetric(_analytics.METRIC_TYPE.CLICK, `${visType.name}:create`);
    }
    if (!('alias' in visType)) {
      // this visualization is not an alias
      appId = 'visualize';
      path = `#/create?type=${encodeURIComponent(visType.name)}`;
    } else if (visType.alias && 'path' in visType.alias) {
      // this visualization **is** an alias, and it has an app to redirect to for creation
      appId = visType.alias.app;
      path = visType.alias.path;
    }
  } else {
    appId = 'visualize';
    path = '#/create?';
  }
  const stateTransferService = _kibana_services.embeddableService.getStateTransfer();
  stateTransferService.navigateToEditor(appId, {
    path,
    state: {
      originatingApp: (_api$getAppContext = api.getAppContext()) === null || _api$getAppContext === void 0 ? void 0 : _api$getAppContext.currentAppId,
      originatingPath: (_api$getAppContext2 = api.getAppContext()) === null || _api$getAppContext2 === void 0 ? void 0 : (_api$getAppContext2$g = _api$getAppContext2.getCurrentPath) === null || _api$getAppContext2$g === void 0 ? void 0 : _api$getAppContext2$g.call(_api$getAppContext2),
      searchSessionId: _kibana_services.dataService.search.session.getSessionId()
    }
  });
}