"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardApi = getDashboardApi;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _dashboard_container_references = require("../../common/dashboard_container/persistable_state/dashboard_container_references");
var _plugin_constants = require("../plugin_constants");
var _dashboard_backup_service = require("../services/dashboard_backup_service");
var _dashboard_content_management_service = require("../services/dashboard_content_management_service");
var _data_loading_manager = require("./data_loading_manager");
var _data_views_manager = require("./data_views_manager");
var _default_dashboard_input = require("./default_dashboard_input");
var _get_serialized_state = require("./get_serialized_state");
var _open_save_modal = require("./open_save_modal");
var _panels_manager = require("./panels_manager");
var _search_session_manager = require("./search_session_manager");
var _settings_manager = require("./settings_manager");
var _track_contentful_render = require("./track_contentful_render");
var _track_overlay = require("./track_overlay");
var _track_panel = require("./track_panel");
var _types = require("./types");
var _unified_search_manager = require("./unified_search_manager");
var _unsaved_changes_manager = require("./unsaved_changes_manager");
var _view_mode_manager = require("./view_mode_manager");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getDashboardApi({
  creationOptions,
  incomingEmbeddable,
  initialState,
  initialPanelsRuntimeState,
  savedObjectResult,
  savedObjectId
}) {
  var _creationOptions$full, _savedObjectResult$ma, _omit;
  const controlGroupApi$ = new _rxjs.BehaviorSubject(undefined);
  const fullScreenMode$ = new _rxjs.BehaviorSubject((_creationOptions$full = creationOptions === null || creationOptions === void 0 ? void 0 : creationOptions.fullScreenMode) !== null && _creationOptions$full !== void 0 ? _creationOptions$full : false);
  const isManaged = (_savedObjectResult$ma = savedObjectResult === null || savedObjectResult === void 0 ? void 0 : savedObjectResult.managed) !== null && _savedObjectResult$ma !== void 0 ? _savedObjectResult$ma : false;
  const savedObjectId$ = new _rxjs.BehaviorSubject(savedObjectId);
  const viewModeManager = (0, _view_mode_manager.initializeViewModeManager)(incomingEmbeddable, savedObjectResult);
  const trackPanel = (0, _track_panel.initializeTrackPanel)(async id => await panelsManager.api.untilEmbeddableLoaded(id));
  const references$ = new _rxjs.BehaviorSubject(initialState.references);
  const getPanelReferences = id => {
    var _references$$value, _references$$value2;
    const panelReferences = (0, _dashboard_container_references.getReferencesForPanelId)(id, (_references$$value = references$.value) !== null && _references$$value !== void 0 ? _references$$value : []);
    // references from old installations may not be prefixed with panel id
    // fall back to passing all references in these cases to preserve backwards compatability
    return panelReferences.length > 0 ? panelReferences : (_references$$value2 = references$.value) !== null && _references$$value2 !== void 0 ? _references$$value2 : [];
  };
  const pushPanelReferences = refs => {
    var _references$$value3;
    references$.next([...((_references$$value3 = references$.value) !== null && _references$$value3 !== void 0 ? _references$$value3 : []), ...refs]);
  };
  const referencesComparator = {
    references: [references$, nextRefs => references$.next(nextRefs)]
  };
  const panelsManager = (0, _panels_manager.initializePanelsManager)(incomingEmbeddable, initialState.panels, initialPanelsRuntimeState !== null && initialPanelsRuntimeState !== void 0 ? initialPanelsRuntimeState : {}, trackPanel, getPanelReferences, pushPanelReferences);
  const dataLoadingManager = (0, _data_loading_manager.initializeDataLoadingManager)(panelsManager.api.children$);
  const dataViewsManager = (0, _data_views_manager.initializeDataViewsManager)(controlGroupApi$, panelsManager.api.children$);
  const settingsManager = (0, _settings_manager.initializeSettingsManager)(initialState);
  const unifiedSearchManager = (0, _unified_search_manager.initializeUnifiedSearchManager)(initialState, controlGroupApi$, settingsManager.api.timeRestore$, dataLoadingManager.internalApi.waitForPanelsToLoad$, () => unsavedChangesManager.internalApi.getLastSavedState(), creationOptions);
  const unsavedChangesManager = (0, _unsaved_changes_manager.initializeUnsavedChangesManager)({
    creationOptions,
    controlGroupApi$,
    lastSavedState: (_omit = (0, _lodash.omit)(savedObjectResult === null || savedObjectResult === void 0 ? void 0 : savedObjectResult.dashboardInput, 'controlGroupInput')) !== null && _omit !== void 0 ? _omit : {
      ..._default_dashboard_input.DEFAULT_DASHBOARD_INPUT
    },
    panelsManager,
    savedObjectId$,
    settingsManager,
    viewModeManager,
    unifiedSearchManager,
    referencesComparator
  });
  function getState() {
    const {
      panels,
      references: panelReferences
    } = panelsManager.internalApi.getState();
    const {
      state: unifiedSearchState,
      references: searchSourceReferences
    } = unifiedSearchManager.internalApi.getState();
    const dashboardState = {
      ...settingsManager.internalApi.getState(),
      ...unifiedSearchState,
      panels,
      viewMode: viewModeManager.api.viewMode$.value
    };
    const controlGroupApi = controlGroupApi$.value;
    let controlGroupReferences;
    if (controlGroupApi) {
      const {
        rawState: controlGroupSerializedState,
        references: extractedReferences
      } = controlGroupApi.serializeState();
      controlGroupReferences = extractedReferences;
      dashboardState.controlGroupInput = controlGroupSerializedState;
    }
    return {
      dashboardState,
      controlGroupReferences,
      panelReferences,
      searchSourceReferences
    };
  }
  const trackOverlayApi = (0, _track_overlay.initializeTrackOverlay)(trackPanel.setFocusedPanelId);
  const dashboardApi = {
    ...viewModeManager.api,
    ...dataLoadingManager.api,
    ...dataViewsManager.api,
    ...panelsManager.api,
    ...settingsManager.api,
    ...trackPanel,
    ...unifiedSearchManager.api,
    ...unsavedChangesManager.api,
    ...trackOverlayApi,
    ...(0, _track_contentful_render.initializeTrackContentfulRender)(),
    controlGroupApi$,
    executionContext: {
      type: 'dashboard',
      description: settingsManager.api.title$.value
    },
    fullScreenMode$,
    getAppContext: () => {
      var _creationOptions$getE, _embeddableAppContext;
      const embeddableAppContext = creationOptions === null || creationOptions === void 0 ? void 0 : (_creationOptions$getE = creationOptions.getEmbeddableAppContext) === null || _creationOptions$getE === void 0 ? void 0 : _creationOptions$getE.call(creationOptions, savedObjectId$.value);
      return {
        ...embeddableAppContext,
        currentAppId: (_embeddableAppContext = embeddableAppContext === null || embeddableAppContext === void 0 ? void 0 : embeddableAppContext.currentAppId) !== null && _embeddableAppContext !== void 0 ? _embeddableAppContext : _plugin_constants.DASHBOARD_APP_ID
      };
    },
    isEmbeddedExternally: Boolean(creationOptions === null || creationOptions === void 0 ? void 0 : creationOptions.isEmbeddedExternally),
    isManaged,
    reload$: (0, _rxjs.merge)(unifiedSearchManager.internalApi.controlGroupReload$, unifiedSearchManager.internalApi.panelsReload$).pipe((0, _rxjs.debounceTime)(0)),
    getSerializedState: () => (0, _get_serialized_state.getSerializedState)(getState()),
    runInteractiveSave: async () => {
      trackOverlayApi.clearOverlays();
      const saveResult = await (0, _open_save_modal.openSaveModal)({
        isManaged,
        lastSavedId: savedObjectId$.value,
        viewMode: viewModeManager.api.viewMode$.value,
        ...getState()
      });
      if (saveResult) {
        var _settings$hidePanelTi;
        unsavedChangesManager.internalApi.onSave(saveResult.savedState);
        const settings = settingsManager.api.getSettings();
        settingsManager.api.setSettings({
          ...settings,
          hidePanelTitles: (_settings$hidePanelTi = settings.hidePanelTitles) !== null && _settings$hidePanelTi !== void 0 ? _settings$hidePanelTi : false,
          description: saveResult.savedState.description,
          tags: saveResult.savedState.tags,
          timeRestore: saveResult.savedState.timeRestore,
          title: saveResult.savedState.title
        });
        savedObjectId$.next(saveResult.id);
        references$.next(saveResult.references);
      }
      return saveResult;
    },
    runQuickSave: async () => {
      if (isManaged) return;
      const {
        controlGroupReferences,
        dashboardState,
        panelReferences,
        searchSourceReferences
      } = getState();
      const saveResult = await (0, _dashboard_content_management_service.getDashboardContentManagementService)().saveDashboardState({
        controlGroupReferences,
        dashboardState,
        panelReferences,
        searchSourceReferences,
        saveOptions: {},
        lastSavedId: savedObjectId$.value
      });
      unsavedChangesManager.internalApi.onSave(dashboardState);
      references$.next(saveResult.references);
      return;
    },
    savedObjectId$,
    setFullScreenMode: fullScreenMode => fullScreenMode$.next(fullScreenMode),
    setSavedObjectId: id => savedObjectId$.next(id),
    type: _types.DASHBOARD_API_TYPE,
    uuid: (0, _uuid.v4)()
  };
  const searchSessionManager = (0, _search_session_manager.initializeSearchSessionManager)(creationOptions === null || creationOptions === void 0 ? void 0 : creationOptions.searchSessionSettings, incomingEmbeddable, dashboardApi);
  return {
    api: {
      ...dashboardApi,
      ...searchSessionManager.api
    },
    internalApi: {
      ...panelsManager.internalApi,
      ...unifiedSearchManager.internalApi,
      getSerializedStateForControlGroup: () => {
        var _savedObjectResult$da, _references$$value4;
        return {
          rawState: savedObjectResult !== null && savedObjectResult !== void 0 && (_savedObjectResult$da = savedObjectResult.dashboardInput) !== null && _savedObjectResult$da !== void 0 && _savedObjectResult$da.controlGroupInput ? savedObjectResult.dashboardInput.controlGroupInput : {
            autoApplySelections: true,
            chainingSystem: 'HIERARCHICAL',
            controls: [],
            ignoreParentSettings: {
              ignoreFilters: false,
              ignoreQuery: false,
              ignoreTimerange: false,
              ignoreValidations: false
            },
            labelPosition: 'oneLine',
            showApplySelections: false
          },
          references: (0, _dashboard_container_references.getReferencesForControls)((_references$$value4 = references$.value) !== null && _references$$value4 !== void 0 ? _references$$value4 : [])
        };
      },
      getRuntimeStateForControlGroup: () => {
        return panelsManager.api.getRuntimeStateForChild(_dashboard_backup_service.PANELS_CONTROL_GROUP_KEY);
      },
      setControlGroupApi: controlGroupApi => controlGroupApi$.next(controlGroupApi)
    },
    cleanup: () => {
      dataLoadingManager.cleanup();
      dataViewsManager.cleanup();
      searchSessionManager.cleanup();
      unifiedSearchManager.cleanup();
      unsavedChangesManager.cleanup();
    }
  };
}