"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SampleClientReadme = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _cuid = require("@paralleldrive/cuid2");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _es = _interopRequireDefault(require("../../../assets/language_clients/es.svg"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CenterColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 740px;
`;
const FixedHeader = _styledComponents.default.div`
  width: 100%;
  height: 196px;
  border-bottom: 1px solid ${_uiTheme.euiThemeVars.euiColorLightShade};
`;
const IconPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  padding: ${props => props.theme.eui.euiSizeXL};
  width: ${props => parseFloat(props.theme.eui.euiSize) * 6 + parseFloat(props.theme.eui.euiSizeXL) * 2}px;
  svg,
  img {
    height: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
    width: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
  }
  .euiFlexItem {
    height: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
    justify-content: center;
  }
`;
const TopFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  max-width: 1150px;
  margin-left: auto;
  margin-right: auto;
  padding: calc(${_uiTheme.euiThemeVars.euiSizeXL} * 2) ${_uiTheme.euiThemeVars.euiSizeM} 0 ${_uiTheme.euiThemeVars.euiSizeM};
`;
const SampleClientReadme = () => {
  const [apiKey, setApiKey] = (0, _react.useState)(null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FixedHeader, null, /*#__PURE__*/_react.default.createElement(TopFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(IconPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "fullWidth",
    src: _es.default,
    alt: "icon"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.sample.readme.title",
    defaultMessage: "Elasticsearch Sample Client"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(CenterColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    panelled: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "customIntegrations.languageClients.sample.readme.intro",
      defaultMessage: "Getting started with the Sample Language Client requires a few steps."
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.sample.readme.install",
    defaultMessage: "Install the Sample Language Client"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "shell",
    isCopyable: true
  }, `# Grab the sample language client from NPM and install it in your project \n`, `$ npm install @elastic/elasticsearch-sample`)), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.sample.readme.createApiKey",
    defaultMessage: "Create an API key"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.sample.readme.apiKey",
    defaultMessage: "Use the button bellow to generate an API key. You'll need this set up your client in the next step."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setApiKey((0, _cuid.createId)()),
    disabled: !!apiKey
  }, "Generate API key")), apiKey && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    paddingSize: "s",
    isCopyable: true,
    className: "eui-displayInline"
  }, apiKey)))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.sample.readme.configure",
    defaultMessage: "Configure the Sample Language Client"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.sample.readme.configureText",
    defaultMessage: "Create an {filename} file in the root of your project, and add the following options.",
    values: {
      filename: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "elastic.config.json")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    language: "json"
  }, `
{
  "apiKey": "${apiKey || 'YOUR_API_KEY'}
}

          `)))))));
};
exports.SampleClientReadme = SampleClientReadme;