"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractMigrationInfo = void 0;
var _semver = require("semver");
var _std = require("@kbn/std");
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Extract all migration-relevant informations bound to given type in a serializable format.
 *
 * @param soType
 */
const extractMigrationInfo = soType => {
  var _soType$modelVersions, _soType$mappings;
  const migrationMap = typeof soType.migrations === 'function' ? soType.migrations() : soType.migrations;
  const migrationVersions = Object.keys(migrationMap !== null && migrationMap !== void 0 ? migrationMap : {});
  migrationVersions.sort(_semver.compare);
  const schemaMap = typeof soType.schemas === 'function' ? soType.schemas() : soType.schemas;
  const schemaVersions = Object.keys(schemaMap !== null && schemaMap !== void 0 ? schemaMap : {});
  schemaVersions.sort(_semver.compare);
  const modelVersionMap = typeof soType.modelVersions === 'function' ? soType.modelVersions() : (_soType$modelVersions = soType.modelVersions) !== null && _soType$modelVersions !== void 0 ? _soType$modelVersions : {};
  const modelVersionIds = Object.keys(modelVersionMap);
  const modelVersions = modelVersionIds.map(version => {
    var _entry$schemas;
    const entry = modelVersionMap[version];
    return {
      version,
      changeTypes: [...new Set(entry.changes.map(change => change.type))].sort(),
      hasTransformation: hasTransformation(entry.changes),
      newMappings: Object.keys((0, _std.getFlattenedObject)((0, _coreSavedObjectsBaseServerInternal.aggregateMappingAdditions)(entry.changes))),
      schemas: {
        forwardCompatibility: !!((_entry$schemas = entry.schemas) !== null && _entry$schemas !== void 0 && _entry$schemas.forwardCompatibility)
      }
    };
  });
  return {
    name: soType.name,
    namespaceType: soType.namespaceType,
    convertToAliasScript: soType.convertToAliasScript,
    convertToMultiNamespaceTypeVersion: soType.convertToMultiNamespaceTypeVersion,
    migrationVersions,
    schemaVersions,
    mappings: (0, _std.getFlattenedObject)((_soType$mappings = soType.mappings) !== null && _soType$mappings !== void 0 ? _soType$mappings : {}),
    hasExcludeOnUpgrade: !!soType.excludeOnUpgrade,
    modelVersions
  };
};
exports.extractMigrationInfo = extractMigrationInfo;
const changesWithTransform = ['data_backfill', 'data_removal', 'unsafe_transform'];
const hasTransformation = changes => {
  return changes.some(change => changesWithTransform.includes(change.type));
};