"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerServiceConfig = registerServiceConfig;
var _utils = require("@kbn/utils");
var _coreLoggingServerInternal = require("@kbn/core-logging-server-internal");
var _coreConfigServerInternal = require("@kbn/core-config-server-internal");
var _coreNodeServerInternal = require("@kbn/core-node-server-internal");
var _coreEnvironmentServerInternal = require("@kbn/core-environment-server-internal");
var _coreExecutionContextServerInternal = require("@kbn/core-execution-context-server-internal");
var _coreHttpServerInternal = require("@kbn/core-http-server-internal");
var _coreElasticsearchServerInternal = require("@kbn/core-elasticsearch-server-internal");
var _coreAppsServerInternal = require("@kbn/core-apps-server-internal");
var _coreMetricsServerInternal = require("@kbn/core-metrics-server-internal");
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
var _coreI18nServerInternal = require("@kbn/core-i18n-server-internal");
var _coreDeprecationsServerInternal = require("@kbn/core-deprecations-server-internal");
var _coreStatusServerInternal = require("@kbn/core-status-server-internal");
var _coreUiSettingsServerInternal = require("@kbn/core-ui-settings-server-internal");
var _corePluginsServerInternal = require("@kbn/core-plugins-server-internal");
var _coreFeatureFlagsServerInternal = require("@kbn/core-feature-flags-server-internal");
var _elastic_config = require("./root/elastic_config");
var _serverless_config = require("./root/serverless_config");
var _core_config = require("./core_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const rootConfigPath = '';
function registerServiceConfig(configService) {
  const configDescriptors = [_core_config.coreConfig, _coreHttpServerInternal.cspConfig, _coreDeprecationsServerInternal.config, _coreElasticsearchServerInternal.config, _coreAppsServerInternal.config, _elastic_config.elasticApmConfig, _coreExecutionContextServerInternal.executionContextConfig, _coreFeatureFlagsServerInternal.featureFlagsConfig, _coreHttpServerInternal.externalUrlConfig, _coreHttpServerInternal.config, _coreI18nServerInternal.config, _coreLoggingServerInternal.config, _coreNodeServerInternal.nodeConfig, _coreMetricsServerInternal.opsConfig, _utils.config, _coreEnvironmentServerInternal.pidConfig, _corePluginsServerInternal.config, _coreSavedObjectsBaseServerInternal.savedObjectsConfig, _coreSavedObjectsBaseServerInternal.savedObjectsMigrationConfig, _serverless_config.serverlessConfig, _coreStatusServerInternal.statusConfig, _coreUiSettingsServerInternal.uiSettingsConfig, _coreHttpServerInternal.permissionsPolicyConfig];
  configService.addDeprecationProvider(rootConfigPath, _coreConfigServerInternal.coreDeprecationProvider);
  for (const descriptor of configDescriptors) {
    if (descriptor.deprecations) {
      configService.addDeprecationProvider(descriptor.path, descriptor.deprecations);
    }
    configService.setSchema(descriptor.path, descriptor.schema);
  }
}