"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PatternLayout = void 0;
var _coreLoggingCommonInternal = require("@kbn/core-logging-common-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_PATTERN = `[%date][%level][%logger] %message`;
const conversions = [_coreLoggingCommonInternal.LoggerConversion, _coreLoggingCommonInternal.MessageConversion, _coreLoggingCommonInternal.LevelConversion, _coreLoggingCommonInternal.MetaConversion, _coreLoggingCommonInternal.DateConversion];

/**
 * Layout that formats `LogRecord` using the `pattern` string with optional
 * color highlighting (eg. to make log messages easier to read in the terminal).
 * @internal
 */
class PatternLayout extends _coreLoggingCommonInternal.PatternLayout {
  constructor(pattern = DEFAULT_PATTERN) {
    super({
      pattern,
      highlight: false,
      conversions
    });
  }
}
exports.PatternLayout = PatternLayout;