"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppMenuBar = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _header_action_menu = require("../header/header_action_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const AppMenuBar = ({
  headerActionMenuMounter
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const zIndex = typeof euiTheme.levels.header === 'number' ? euiTheme.levels.header - 1 // We want it to appear right below the header
  : euiTheme.levels.header;
  return /*#__PURE__*/_react2.default.createElement("div", {
    className: "header__actionMenu",
    "data-test-subj": "kibanaProjectHeaderActionMenu",
    css: (0, _react.css)`
        z-index: ${zIndex};
        background: ${euiTheme.colors.body};
        border-bottom: ${euiTheme.border.thin};
        display: flex;
        justify-content: end;
        align-items: center;
        padding: 0 ${euiTheme.size.s};
        height: var(--kbnProjectHeaderAppActionMenuHeight, ${euiTheme.size.xxxl});
        margin-bottom: -${euiTheme.border.width.thin};
        /* fixates the elements position in the viewport, removes the element from the flow of the page */
        position: sticky;
        /* position below the primary fixed EuiHeader in the viewport */
        top: var(--euiFixedHeadersOffset, 0);
      `
  }, /*#__PURE__*/_react2.default.createElement(_header_action_menu.HeaderActionMenu, {
    mounter: headerActionMenuMounter
  }));
};
exports.AppMenuBar = AppMenuBar;