"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLocationObservable = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// interface compatible for both window.location and history.location...

const getLocationObservable = (initialLocation, history) => {
  const subject = new _rxjs.Subject();
  history.listen(location => {
    subject.next(locationToUrl(location));
  });
  return subject.pipe((0, _rxjs.startWith)(locationToUrl(initialLocation)), (0, _rxjs.distinctUntilChanged)(), (0, _rxjs.shareReplay)(1));
};
exports.getLocationObservable = getLocationObservable;
const locationToUrl = location => {
  return `${location.pathname}${location.hash}`;
};