"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _options_list_popover_action_bar = require("./options_list_popover_action_bar");
var _options_list_context_provider = require("../options_list_context_provider");
var _options_list_popover_footer = require("./options_list_popover_footer");
var _options_list_popover_invalid_selections = require("./options_list_popover_invalid_selections");
var _options_list_popover_suggestions = require("./options_list_popover_suggestions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const OptionsListPopover = () => {
  const {
    api,
    displaySettings
  } = (0, _options_list_context_provider.useOptionsListContext)();
  const [field, availableOptions, invalidSelections, loading] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.field$, api.availableOptions$, api.invalidSelections$, api.dataLoading$);
  const [showOnlySelected, setShowOnlySelected] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement("div", {
    id: `control-popover-${api.uuid}`,
    className: 'optionsList__popover',
    "data-test-subj": `optionsList-control-popover`
  }, (field === null || field === void 0 ? void 0 : field.type) !== 'boolean' && !displaySettings.hideActionBar && /*#__PURE__*/_react.default.createElement(_options_list_popover_action_bar.OptionsListPopoverActionBar, {
    showOnlySelected: showOnlySelected,
    setShowOnlySelected: setShowOnlySelected
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `optionsList-control-available-options`,
    "data-option-count": loading ? 0 : Object.keys(availableOptions !== null && availableOptions !== void 0 ? availableOptions : {}).length,
    css: {
      width: '100%',
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_options_list_popover_suggestions.OptionsListPopoverSuggestions, {
    showOnlySelected: showOnlySelected
  }), !showOnlySelected && invalidSelections && invalidSelections.size !== 0 && /*#__PURE__*/_react.default.createElement(_options_list_popover_invalid_selections.OptionsListPopoverInvalidSelections, null)), !displaySettings.hideExclude && /*#__PURE__*/_react.default.createElement(_options_list_popover_footer.OptionsListPopoverFooter, null));
};
exports.OptionsListPopover = OptionsListPopover;