"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchContentQuery = exports.useGetContentQuery = void 0;
var _reactQuery = require("@tanstack/react-query");
var _content_client_context = require("./content_client_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Exposed `useQuery` options
 */

/**
 *
 * @param input - get content identifier like "id" and "contentType"
 * @param queryOptions - query options
 */
const useGetContentQuery = (input, queryOptions) => {
  const contentClient = (0, _content_client_context.useContentClient)();
  return (0, _reactQuery.useQuery)({
    ...contentClient.queryOptionBuilder.get(input),
    ...queryOptions
  });
};

/**
 *
 * @param input - get content identifier like "id" and "contentType"
 * @param queryOptions - query options
 */
exports.useGetContentQuery = useGetContentQuery;
const useSearchContentQuery = (input, queryOptions) => {
  const contentClient = (0, _content_client_context.useContentClient)();
  return (0, _reactQuery.useQuery)({
    ...contentClient.queryOptionBuilder.search(input),
    ...queryOptions
  });
};
exports.useSearchContentQuery = useSearchContentQuery;