"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnassignedTermsConfig = UnassignedTermsConfig;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _react2 = require("@emotion/react");
var _palettes = require("@kbn/palettes");
var _color_mapping = require("../../state/color_mapping");
var _default_color_mapping = require("../../config/default_color_mapping");
var _special_assignment = require("../assignment/special_assignment");
var _selectors = require("../../state/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function UnassignedTermsConfig({
  palettes,
  data,
  isDarkMode
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const neutralPalette = palettes.get(_palettes.KbnPalette.Neutral);
  const palette = (0, _reactRedux.useSelector)((0, _selectors.selectPalette)(palettes));
  const colorMode = (0, _reactRedux.useSelector)(_selectors.selectColorMode);
  const specialAssignments = (0, _reactRedux.useSelector)(_selectors.selectSpecialAssignments);
  const otherAssignment = specialAssignments[_default_color_mapping.DEFAULT_OTHER_ASSIGNMENT_INDEX];
  const colorModes = [{
    id: 'loop',
    label: colorMode.type === 'gradient' ? _i18n.i18n.translate('coloring.colorMapping.container.unassignedTermsMode.ReuseGradientLabel', {
      defaultMessage: 'Gradient'
    }) : _i18n.i18n.translate('coloring.colorMapping.container.unassignedTermsMode.ReuseColorsLabel', {
      defaultMessage: 'Color palette'
    })
  }, {
    id: 'static',
    label: _i18n.i18n.translate('coloring.colorMapping.container.unassignedTermsMode.SingleColorLabel', {
      defaultMessage: 'Single color'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('coloring.colorMapping.container.unassignedTermsModeHeader', {
      defaultMessage: 'Color for unassigned terms'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: 'Color mode',
    options: colorModes,
    idSelected: otherAssignment.color.type === 'loop' ? 'loop' : 'static',
    onChange: optionId => {
      dispatch((0, _color_mapping.updateSpecialAssignmentColor)({
        assignmentIndex: 0,
        color: optionId === 'loop' ? {
          type: 'loop'
        } : {
          type: 'categorical',
          colorIndex: _default_color_mapping.DEFAULT_NEUTRAL_PALETTE_INDEX,
          paletteId: neutralPalette.id
        }
      }));
    },
    buttonSize: "compressed",
    isFullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              visibility: ${otherAssignment.color.type === 'loop' ? 'hidden' : 'visible'};
              width: 32px;
              height: 32px;
            `
  }, data.type === 'categories' && otherAssignment.color.type !== 'loop' && /*#__PURE__*/_react.default.createElement(_special_assignment.SpecialAssignment, {
    index: 0,
    palette: palette,
    isDarkMode: isDarkMode,
    palettes: palettes,
    assignmentColor: otherAssignment.color,
    total: specialAssignments.length
  })))));
}