"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupCdrDataViews = exports.installDataView = void 0;
var _common = require("@kbn/spaces-plugin/common");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_VIEW_TIME_FIELD = '@timestamp';
const getDataViewSafe = async (soClient, currentSpaceId, currentSpaceDataViewId) => {
  try {
    const dataView = await soClient.get('index-pattern', currentSpaceDataViewId, {
      namespace: currentSpaceId
    });
    return dataView;
  } catch (e) {
    return;
  }
};
const getCurrentSpaceId = (spacesService, request) => {
  return (spacesService === null || spacesService === void 0 ? void 0 : spacesService.getSpaceId(request)) || _common.DEFAULT_SPACE_ID;
};
const installDataView = async (esClient, soClient, spacesService, dataViewsService, request, dataViewName, indexPattern, dataViewId, logger) => {
  try {
    const currentSpaceId = await getCurrentSpaceId(spacesService, request);
    const currentSpaceDataViewId = `${dataViewId}-${currentSpaceId}`;
    const doesDataViewExist = await getDataViewSafe(soClient, currentSpaceId, currentSpaceDataViewId);
    if (doesDataViewExist) return;
    logger.info(`Creating and saving data view with ID: ${currentSpaceDataViewId}`);
    const dataViewsClient = await dataViewsService.dataViewsServiceFactory(soClient, esClient, request, true);
    await dataViewsClient.createAndSave({
      id: currentSpaceDataViewId,
      title: indexPattern,
      name: `${dataViewName} - ${currentSpaceId} `,
      namespaces: [currentSpaceId],
      allowNoIndex: true,
      timeFieldName: DATA_VIEW_TIME_FIELD
    }, true);
  } catch (error) {
    logger.error(`Failed to setup data view`, error);
  }
};
exports.installDataView = installDataView;
const setupCdrDataViews = async (esClient, soClient, spacesService, dataViewsService, request, logger) => {
  await installDataView(esClient, soClient, spacesService, dataViewsService, request, _cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_DATA_VIEW_NAME, _cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_INDEX_PATTERN, _cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX, logger);
  await installDataView(esClient, soClient, spacesService, dataViewsService, request, _constants.CDR_VULNERABILITIES_DATA_VIEW_NAME, _cloudSecurityPostureCommon.CDR_VULNERABILITIES_INDEX_PATTERN, _constants.CDR_VULNERABILITIES_DATA_VIEW_ID_PREFIX, logger);
};
exports.setupCdrDataViews = setupCdrDataViews;