"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindingsDistributionBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const I18N_PASSED_FINDINGS = _i18n.i18n.translate('xpack.csp.findings.distributionBar.totalPassedLabel', {
  defaultMessage: 'Passed Findings'
});
const I18N_FAILED_FINDINGS = _i18n.i18n.translate('xpack.csp.findings.distributionBar.totalFailedLabel', {
  defaultMessage: 'Failed Findings'
});
const FindingsDistributionBar = props => /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(Counters, props), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(DistributionBar, props));
exports.FindingsDistributionBar = FindingsDistributionBar;
const Counters = ({
  passed,
  failed
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    css: (0, _react2.css)`
        gap: ${euiTheme.size.m};
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: (0, _cloudSecurityPosture.getMisconfigurationStatusColor)(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.PASSED)
  }, I18N_PASSED_FINDINGS), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, (0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(passed)), /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: (0, _cloudSecurityPosture.getMisconfigurationStatusColor)(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.FAILED)
  }, I18N_FAILED_FINDINGS), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, (0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(failed)));
};
const DistributionBar = ({
  passed,
  failed,
  distributionOnClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: (0, _react2.css)`
        height: 8px;
        background: ${euiTheme.colors.lightestShade};
      `
  }, /*#__PURE__*/_react.default.createElement(DistributionBarPart, {
    value: passed,
    color: (0, _cloudSecurityPosture.getMisconfigurationStatusColor)(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.PASSED),
    distributionOnClick: () => {
      distributionOnClick(_constants.RULE_PASSED);
    },
    "data-test-subj": "distribution_bar_passed",
    "aria-label": `${I18N_PASSED_FINDINGS}: ${passed}`
  }), /*#__PURE__*/_react.default.createElement(DistributionBarPart, {
    value: failed,
    color: (0, _cloudSecurityPosture.getMisconfigurationStatusColor)(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.FAILED),
    distributionOnClick: () => {
      distributionOnClick(_constants.RULE_FAILED);
    },
    "data-test-subj": "distribution_bar_failed",
    "aria-label": `${I18N_FAILED_FINDINGS}: ${failed}`
  }));
};
const DistributionBarPart = ({
  value,
  color,
  distributionOnClick,
  ...rest
}) => /*#__PURE__*/_react.default.createElement("button", {
  "data-test-subj": rest['data-test-subj'],
  "aria-label": rest['aria-label'],
  onClick: distributionOnClick,
  css: {
    background: color,
    height: '100%'
  },
  style: {
    flex: value
  }
});