"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspInlineDescriptionList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CopyButton = ({
  copyText
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
  textToCopy: copyText
}, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  css: (0, _react2.css)`
          :hover {
            cursor: pointer;
          }
        `,
  onClick: copy,
  type: "copy"
}));
const getModifiedTitlesListItems = listItems => listItems === null || listItems === void 0 ? void 0 : listItems.filter(item => !!(item !== null && item !== void 0 && item.title) && !!(item !== null && item !== void 0 && item.description)).map(item => ({
  ...item,
  title: `${item.title}:`,
  description: typeof item.description === 'string' ? /*#__PURE__*/_react.default.createElement("span", null, item.description, " ", /*#__PURE__*/_react.default.createElement(CopyButton, {
    copyText: item.description
  })) : item.description
}));

// eui size m is 12px which is too small, and next after it is base which is 16px which is too big
const fontSize = '1rem';
const CspInlineDescriptionList = ({
  testId,
  listItems
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const modifiedTitlesListItems = getModifiedTitlesListItems(listItems);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": testId,
    type: "inline",
    titleProps: {
      style: {
        background: 'initial',
        color: euiTheme.colors.subduedText,
        fontSize,
        paddingRight: 0,
        paddingInline: 0
      }
    },
    descriptionProps: {
      style: {
        color: euiTheme.colors.subduedText,
        marginRight: euiTheme.size.xs,
        fontSize
      }
    },
    listItems: modifiedTitlesListItems
  });
};
exports.CspInlineDescriptionList = CspInlineDescriptionList;