"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCisKubernetesIntegration = void 0;
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/fleet-plugin/common");
var _constants = require("../../../common/constants");
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hook will find our cis integration and return its PackageInfo
 * */
const useCisKubernetesIntegration = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)(['integrations'], () => http.get(_common.epmRouteService.getInfoPath(_constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME), {
    version: _common.API_VERSIONS.public.v1
  }));
};
exports.useCisKubernetesIntegration = useCisKubernetesIntegration;