"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _configSchema = require("@kbn/config-schema");
var _std = require("@kbn/std");
var _camelcaseKeys = _interopRequireDefault(require("camelcase-keys"));
var _register_cloud_deployment_id_analytics_context = require("../common/register_cloud_deployment_id_analytics_context");
var _collectors = require("./collectors");
var _is_cloud_enabled = require("../common/is_cloud_enabled");
var _parse_deployment_id_from_deployment_url = require("../common/parse_deployment_id_from_deployment_url");
var _decode_cloud_id = require("../common/decode_cloud_id");
var _parse_onboarding_default_solution = require("../common/parse_onboarding_default_solution");
var _utils = require("../common/utils");
var _env = require("./env");
var _routes = require("./routes");
var _saved_objects = require("./saved_objects");
var _cloud_data = require("./cloud_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Setup contract
 */

/**
 * Start contract
 */

class CloudPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.context = context;
    this.config = this.context.config.get();
    this.logger = this.context.logger.get();
  }
  setup(core, {
    usageCollection
  }) {
    var _this$config$serverle, _this$config$serverle2, _this$config$serverle3, _decodedId, _decodedId2, _decodedId3, _decodedId4, _this$config$apm, _this$config$apm2, _this$config$onboardi2, _this$config$serverle4;
    const isCloudEnabled = (0, _is_cloud_enabled.getIsCloudEnabled)(this.config.id);
    const organizationId = this.config.organization_id;
    const projectId = (_this$config$serverle = this.config.serverless) === null || _this$config$serverle === void 0 ? void 0 : _this$config$serverle.project_id;
    const projectType = (_this$config$serverle2 = this.config.serverless) === null || _this$config$serverle2 === void 0 ? void 0 : _this$config$serverle2.project_type;
    const orchestratorTarget = (_this$config$serverle3 = this.config.serverless) === null || _this$config$serverle3 === void 0 ? void 0 : _this$config$serverle3.orchestrator_target;
    const isServerlessEnabled = !!projectId;
    const deploymentId = (0, _parse_deployment_id_from_deployment_url.parseDeploymentIdFromDeploymentUrl)(this.config.deployment_url);
    (0, _register_cloud_deployment_id_analytics_context.registerCloudDeploymentMetadataAnalyticsContext)(core.analytics, this.config);
    (0, _collectors.registerCloudUsageCollector)(usageCollection, {
      isCloudEnabled,
      organizationId,
      trialEndDate: this.config.trial_end_date,
      isElasticStaffOwned: this.config.is_elastic_staff_owned,
      deploymentId,
      projectId,
      projectType,
      orchestratorTarget
    });
    const basePath = core.http.basePath.serverBasePath;
    core.http.resources.register({
      path: '/app/cloud/onboarding',
      validate: {
        query: _configSchema.schema.maybe(_configSchema.schema.object({
          next: _configSchema.schema.maybe(_configSchema.schema.string()),
          onboarding_token: _configSchema.schema.maybe(_configSchema.schema.string()),
          security: _configSchema.schema.maybe(_configSchema.schema.object({
            use_case: _configSchema.schema.oneOf([_configSchema.schema.literal('siem'), _configSchema.schema.literal('cloud'), _configSchema.schema.literal('edr'), _configSchema.schema.literal('other')]),
            migration: _configSchema.schema.maybe(_configSchema.schema.object({
              value: _configSchema.schema.boolean(),
              type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('splunk'), _configSchema.schema.literal('other')]))
            }))
          }))
        }, {
          unknowns: 'ignore'
        }))
      },
      security: {
        authz: {
          enabled: false,
          reason: 'Authorization at the API level isn’t required, as it’s implicitly enforced by the scoped `uiSettings` and `SavedObjects` clients used to handle the request.'
        }
      }
    }, async (context, request, response) => {
      var _request$query$onboar, _request$query, _request$query$securi, _request$query2, _this$config$onboardi;
      const {
        uiSettings,
        savedObjects
      } = await context.core;
      const defaultRoute = await uiSettings.client.get('defaultRoute');
      const nextCandidateRoute = (0, _std.parseNextURL)(request.url.href);
      const route = nextCandidateRoute === '/' ? defaultRoute : nextCandidateRoute;
      // need to get rid of ../../ to make sure we will not be out of space basePath
      const normalizedRoute = new URL(route, 'https://localhost');
      const queryOnboardingToken = (_request$query$onboar = (_request$query = request.query) === null || _request$query === void 0 ? void 0 : _request$query.onboarding_token) !== null && _request$query$onboar !== void 0 ? _request$query$onboar : undefined;
      const queryOnboardingSecurityRaw = (_request$query$securi = (_request$query2 = request.query) === null || _request$query2 === void 0 ? void 0 : _request$query2.security) !== null && _request$query$securi !== void 0 ? _request$query$securi : undefined;
      const queryOnboardingSecurity = queryOnboardingSecurityRaw ? (0, _camelcaseKeys.default)(queryOnboardingSecurityRaw, {
        deep: true
      }) : undefined;
      const solutionType = (_this$config$onboardi = this.config.onboarding) === null || _this$config$onboardi === void 0 ? void 0 : _this$config$onboardi.default_solution;
      if (queryOnboardingToken || queryOnboardingSecurity) {
        core.getStartServices().then(async ([coreStart]) => {
          const soClient = savedObjects.getClient({
            includedHiddenTypes: [_saved_objects.CLOUD_DATA_SAVED_OBJECT_TYPE]
          });
          await (0, _cloud_data.persistTokenCloudData)(soClient, {
            logger: this.logger,
            onboardingToken: queryOnboardingToken,
            solutionType,
            security: queryOnboardingSecurity
          });
        }).catch(errorMsg => this.logger.error(errorMsg));
      }
      // preserving of the hash is important for the navigation to work correctly with default route
      return response.redirected({
        headers: {
          location: `${basePath}${normalizedRoute.pathname}${normalizedRoute.search}${normalizedRoute.hash}`
        }
      });
    });
    let decodedId;
    if (this.config.id) {
      decodedId = (0, _decode_cloud_id.decodeCloudId)(this.config.id, this.logger);
    }
    const router = core.http.createRouter();
    const elasticsearchUrl = core.elasticsearch.publicBaseUrl || ((_decodedId = decodedId) === null || _decodedId === void 0 ? void 0 : _decodedId.elasticsearchUrl);
    (0, _routes.defineRoutes)({
      logger: this.logger,
      router,
      elasticsearchUrl
    });
    (0, _saved_objects.setupSavedObjects)(core.savedObjects, this.logger);
    return {
      ...this.getCloudUrls(),
      cloudId: this.config.id,
      csp: this.config.csp,
      organizationId,
      instanceSizeMb: (0, _env.readInstanceSizeMb)(),
      deploymentId,
      elasticsearchUrl,
      kibanaUrl: (_decodedId2 = decodedId) === null || _decodedId2 === void 0 ? void 0 : _decodedId2.kibanaUrl,
      cloudHost: (_decodedId3 = decodedId) === null || _decodedId3 === void 0 ? void 0 : _decodedId3.host,
      cloudDefaultPort: (_decodedId4 = decodedId) === null || _decodedId4 === void 0 ? void 0 : _decodedId4.defaultPort,
      isCloudEnabled,
      trialEndDate: this.config.trial_end_date ? new Date(this.config.trial_end_date) : undefined,
      isElasticStaffOwned: this.config.is_elastic_staff_owned,
      apm: {
        url: (_this$config$apm = this.config.apm) === null || _this$config$apm === void 0 ? void 0 : _this$config$apm.url,
        secretToken: (_this$config$apm2 = this.config.apm) === null || _this$config$apm2 === void 0 ? void 0 : _this$config$apm2.secret_token
      },
      onboarding: {
        defaultSolution: (0, _parse_onboarding_default_solution.parseOnboardingSolution)((_this$config$onboardi2 = this.config.onboarding) === null || _this$config$onboardi2 === void 0 ? void 0 : _this$config$onboardi2.default_solution)
      },
      isServerlessEnabled,
      serverless: {
        projectId,
        projectName: (_this$config$serverle4 = this.config.serverless) === null || _this$config$serverle4 === void 0 ? void 0 : _this$config$serverle4.project_name,
        projectType,
        orchestratorTarget
      }
    };
  }
  start() {
    return {
      ...this.getCloudUrls(),
      isCloudEnabled: (0, _is_cloud_enabled.getIsCloudEnabled)(this.config.id)
    };
  }
  getCloudUrls() {
    const {
      base_url: baseUrl
    } = this.config;
    const projectsUrl = (0, _utils.getFullCloudUrl)(baseUrl, this.config.projects_url);
    return {
      baseUrl,
      projectsUrl
    };
  }
}
exports.CloudPlugin = CloudPlugin;