"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildPalettes = void 0;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _i18n = require("@kbn/i18n");
var _palettes = require("@kbn/palettes");
var _lodash = require("lodash");
var _ = require("../..");
var _mapped_colors = require("../mapped_colors");
var _helpers = require("./helpers");
var _decrease_opacity = require("./decrease_opacity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function buildRoundRobinCategoricalWithMappedColors(id, colors, behindTextColors) {
  const behindTextColorMap = Object.fromEntries((0, _lodash.zip)(colors, behindTextColors));
  const mappedColors = new _mapped_colors.MappedColors(num => {
    return (0, _lodash.flatten)(new Array(Math.ceil(num / 10)).fill(colors)).map(color => color.toLowerCase());
  });
  function getColor(series, chartConfiguration = {
    behindText: false
  }) {
    let outputColor;
    if (chartConfiguration.syncColors) {
      var _behindTextColorMap$m;
      const colorKey = series[0].name;
      mappedColors.mapKeys([colorKey]);
      const mappedColor = mappedColors.get(colorKey);
      outputColor = chartConfiguration.behindText ? (_behindTextColorMap$m = behindTextColorMap[mappedColor]) !== null && _behindTextColorMap$m !== void 0 ? _behindTextColorMap$m : mappedColor : mappedColor;
    } else {
      outputColor = chartConfiguration.behindText && behindTextColors ? behindTextColors[series[0].rankAtDepth % behindTextColors.length] : colors[series[0].rankAtDepth % colors.length];
    }
    if (!chartConfiguration.maxDepth || chartConfiguration.maxDepth === 1) {
      return outputColor;
    }
    return (0, _decrease_opacity.decreaseOpacity)(outputColor, series.length, chartConfiguration.maxDepth);
  }
  return {
    id,
    getCategoricalColor: getColor,
    getCategoricalColors: size => colors.slice(0, size),
    toExpression: () => ({
      type: 'expression',
      chain: [{
        type: 'function',
        function: 'system_palette',
        arguments: {
          name: [id]
        }
      }]
    })
  };
}
function buildGradient(id, palette) {
  function getColor(series, chartConfiguration = {
    behindText: false
  }) {
    const totalSeriesAtDepth = series[0].totalSeriesAtDepth;
    const rankAtDepth = series[0].rankAtDepth;
    const actualColors = palette.colors(totalSeriesAtDepth);
    const outputColor = actualColors[rankAtDepth];
    if (!chartConfiguration.maxDepth || chartConfiguration.maxDepth === 1) {
      return outputColor;
    }
    return (0, _decrease_opacity.decreaseOpacity)(outputColor, series.length, chartConfiguration.maxDepth);
  }
  return {
    id,
    title: palette.name,
    getCategoricalColor: getColor,
    getCategoricalColors: palette.colors,
    canDynamicColoring: true,
    toExpression: () => ({
      type: 'expression',
      chain: [{
        type: 'function',
        function: 'system_palette',
        arguments: {
          name: [id]
        }
      }]
    })
  };
}
function buildCustomPalette() {
  return {
    id: 'custom',
    getColorForValue: (value, params, dataBounds) => {
      return (0, _helpers.workoutColorForValue)(value, params, dataBounds);
    },
    getCategoricalColor: (series, chartConfiguration = {
      behindText: false
    }, {
      colors,
      gradient
    }) => {
      const actualColors = gradient ? _chromaJs.default.scale(colors).colors(series[0].totalSeriesAtDepth) : colors;
      const outputColor = actualColors[series[0].rankAtDepth % actualColors.length];
      if (!chartConfiguration.maxDepth || chartConfiguration.maxDepth === 1) {
        return outputColor;
      }
      return (0, _decrease_opacity.decreaseOpacity)(outputColor, series.length, chartConfiguration.maxDepth);
    },
    internal: true,
    title: _i18n.i18n.translate('charts.palettes.customLabel', {
      defaultMessage: 'Custom'
    }),
    getCategoricalColors: (size, {
      colors,
      gradient,
      stepped,
      stops
    } = {
      colors: [],
      gradient: false,
      stepped: false,
      stops: []
    }) => {
      if (stepped) {
        const range = stops[stops.length - 1] - stops[0];
        const offset = stops[0];
        const finalStops = [...stops.map(stop => (stop - offset) / range)];
        return _chromaJs.default.scale(colors).domain(finalStops).colors(size);
      }
      return gradient ? _chromaJs.default.scale(colors).colors(size) : colors;
    },
    canDynamicColoring: false,
    toExpression: ({
      colors,
      gradient,
      stops = [],
      rangeMax,
      rangeMin,
      rangeType = 'percent',
      continuity = 'above',
      reverse = false
    }) => ({
      type: 'expression',
      chain: [{
        type: 'function',
        function: 'palette',
        arguments: {
          color: colors,
          gradient: [gradient],
          reverse: [reverse],
          continuity: [continuity],
          stop: stops,
          range: [rangeType],
          rangeMax: rangeMax == null ? [] : [rangeMax],
          rangeMin: rangeMin == null ? [] : [rangeMin]
        }
      }]
    })
  };
}
const buildPalettes = theme => {
  var _kbnPalettes$query;
  const kbnPalettes = (0, _palettes.getKbnPalettes)(theme);
  const defaultPalette = kbnPalettes.get(_palettes.KbnPalette.Default);
  return {
    default: {
      title: defaultPalette.name,
      tag: defaultPalette.tag,
      ...buildRoundRobinCategoricalWithMappedColors('default',
      // needs to match key of palette definition
      defaultPalette.colors(), (_kbnPalettes$query = kbnPalettes.query(_palettes.KbnPalette.Kibana7BehindText)) === null || _kbnPalettes$query === void 0 ? void 0 : _kbnPalettes$query.colors())
    },
    status: buildGradient('status', kbnPalettes.get('status')),
    temperature: buildGradient('temperature', kbnPalettes.get('temperature')),
    complementary: buildGradient('complementary', kbnPalettes.get('complementary')),
    negative: buildGradient('negative', kbnPalettes.get('red')),
    positive: buildGradient('positive', kbnPalettes.get('green')),
    cool: buildGradient('cool', kbnPalettes.get('cool')),
    warm: buildGradient('warm', kbnPalettes.get('warm')),
    gray: buildGradient('gray', kbnPalettes.get('gray')),
    kibana_palette: {
      title: _i18n.i18n.translate('charts.palettes.kibanaPaletteLabel', {
        defaultMessage: 'Compatibility'
      }),
      ...buildRoundRobinCategoricalWithMappedColors('kibana_palette', (0, _.createColorPalette)(20))
    },
    custom: buildCustomPalette()
  };
};
exports.buildPalettes = buildPalettes;