/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(self.cases_bundle_jsonpfunction=self.cases_bundle_jsonpfunction||[]).push([[471],{3471:(e,t,a)=>{"use strict";a.r(t),a.d(t,{FileUpload:()=>S,default:()=>k});var l=a(4286),i=a.n(l),o=a(9673),s=a(6791),r=a(7880),n=a(1319);function d(e){return(0,r.A)(e,e.getValue())}const u=i().createContext(null),c=()=>i().useContext(u);var h=a(5008);const p={defaultPickerLabel:h.i18n.translate("sharedUXPackages.fileUpload.defaultFilePickerLabel",{defaultMessage:"Upload a file"}),upload:h.i18n.translate("sharedUXPackages.fileUpload.uploadButtonLabel",{defaultMessage:"Upload"}),uploading:h.i18n.translate("sharedUXPackages.fileUpload.uploadingButtonLabel",{defaultMessage:"Uploading"}),uploadComplete:h.i18n.translate("sharedUXPackages.fileUpload.uploadCompleteButtonLabel",{defaultMessage:"Upload complete"}),retry:h.i18n.translate("sharedUXPackages.fileUpload.retryButtonLabel",{defaultMessage:"Retry"}),clear:h.i18n.translate("sharedUXPackages.fileUpload.clearButtonLabel",{defaultMessage:"Clear"}),cancel:h.i18n.translate("sharedUXPackages.fileUpload.cancelButtonLabel",{defaultMessage:"Cancel"}),uploadDone:h.i18n.translate("sharedUXPackages.fileUpload.uploadDoneToolTipContent",{defaultMessage:"Your file was successfully uploaded!"}),fileTooLarge:e=>h.i18n.translate("sharedUXPackages.fileUpload.fileTooLargeErrorMessage",{defaultMessage:"File is too large. Maximum size is {expectedSize, plural, one {# byte} other {# bytes} }.",values:{expectedSize:e}}),mimeTypeNotSupported:(e,t)=>h.i18n.translate("sharedUXPackages.fileUpload.mimeTypeNotSupportedErrorMessage",{defaultMessage:'File mime type "{mimeType}" is not supported. Supported mime types are: {supportedMimeTypes}.',values:{mimeType:e,supportedMimeTypes:t}})},f=({onClick:e})=>{const t=c(),a=d(t.uploading$),l=d(t.error$),i=(0,r.A)(t.done$),o=(0,r.A)(t.files$,[]);return(0,s.jsx)(n.EuiButton,{key:"uploadButton",isLoading:a,color:i?"success":"primary",fill:!0,iconType:i?"checkInCircleFilled":void 0,disabled:Boolean(!o.length||l||i),onClick:e,size:"s","data-test-subj":"uploadButton"},i?p.uploadComplete:a?p.uploading:p.upload)},m=({onClick:e})=>{const t=d(c().uploading$);return(0,s.jsx)(n.EuiButton,{key:"retryButton",size:"s","data-test-subj":"retryButton",disabled:t,onClick:e},p.retry)},g=({onClick:e,compressed:t})=>{const a=!d(c().uploading$);return t?(0,s.jsx)(n.EuiButtonIcon,{color:"danger","data-test-subj":"cancelButtonIcon",disabled:a,iconType:"cross","aria-label":p.cancel,onClick:e}):(0,s.jsx)(n.EuiButton,{color:"danger",fill:!0,key:"cancelButton",size:"s","data-test-subj":"cancelButton",disabled:a,onClick:e},p.cancel)},b=({onCancel:e,onUpload:t,immediate:a,compressed:l})=>{const i=c(),o=d(i.uploading$),n=(0,r.A)(i.files$,[]),u=Boolean(n.some((e=>"upload_failed"===e.status)));return l||o?(0,s.jsx)(g,{compressed:l,onClick:e}):u?(0,s.jsx)(m,{onClick:t}):a?null:(0,s.jsx)(f,{onClick:t})},w=({onClick:e})=>(0,s.jsx)(n.EuiButtonEmpty,{size:"s","data-test-subj":"clearButton",onClick:e,color:"primary"},p.clear),M={horizontalContainer:{name:"ho1qnd",styles:"display:flex;flex-direction:row"},fullWidth:{name:"1d3w5wq",styles:"width:100%"}},x=i().forwardRef((({compressed:e,meta:t,accept:a,immediate:l,allowClear:o=!1,multiple:u,initialFilePromptText:h,fullWidth:f,className:m},g)=>{const{euiTheme:x}=(0,n.useEuiTheme)(),y=c(),v=d(y.uploading$),j=d(y.error$),U=(0,r.A)(y.done$),$=Boolean(j),S=null==j?void 0:j.message,k=(0,n.useGeneratedHtmlId)({prefix:"filesFileUpload"}),B=`${k}_error`;return(0,s.jsx)("div",{"data-test-subj":"filesFileUpload",css:[(0,s.css)("max-width:",f?"100%":x.components.forms.maxWidth,";",""),f?M.fullWidth:void 0,e?M.horizontalContainer:void 0,"",""],className:m},(0,s.jsx)(n.EuiFilePicker,{fullWidth:f,"aria-label":p.defaultPickerLabel,id:k,ref:g,onChange:e=>{y.setFiles(Array.from(null!=e?e:[])),l&&y.hasFiles()&&y.upload(t)},multiple:u,initialPromptText:h,isLoading:v,isInvalid:$,accept:a,disabled:Boolean((null==U?void 0:U.length)||v),"aria-describedby":S?B:void 0,display:e?"default":"large"}),(0,s.jsx)(n.EuiSpacer,{size:"s",css:e?(0,s.css)("width:",x.size.s,";",""):void 0}),(0,s.jsx)(n.EuiFlexGroup,{justifyContent:"flexStart",alignItems:e?"center":"flexStart",direction:e?void 0:"rowReverse",gutterSize:e?"none":"m",responsive:!1},(0,s.jsx)(n.EuiFlexItem,{grow:!1},(0,s.jsx)(b,{compressed:e,immediate:l,onCancel:y.abort,onUpload:()=>y.upload(t)})),!e&&Boolean(!U&&!v&&S)&&(0,s.jsx)(n.EuiFlexItem,null,(0,s.jsx)(n.EuiText,{"data-test-subj":"error",css:(0,s.css)("display:flex;align-items:center;min-height:",x.size.xl,";",""),size:"s",color:"danger"},(0,s.jsx)("span",{id:B},S))),!e&&(null==U?void 0:U.length)&&o&&(0,s.jsx)(i().Fragment,null,(0,s.jsx)(n.EuiFlexItem,null)," ",(0,s.jsx)(n.EuiFlexItem,{grow:!1},(0,s.jsx)(w,{onClick:y.clear})))))}));var y=a(8915),v=a(190),j=a(7769);async function U(e){const t=window.URL.createObjectURL(e);try{const e=await function(e){return new Promise(((t,a)=>{const l=new window.Image;l.src=e,l.onload=()=>t(l),l.onerror=a}))}(t),a=document.createElement("canvas"),{width:l,height:i}=function(e,t){const a=Math.abs(Math.min(Math.min(120/e,120/t),1)-1);return{width:Math.floor(e-a*e),height:Math.floor(t-a*t)}}(e.width,e.height);a.width=l,a.height=i;const o=a.getContext("2d");if(!o)throw new Error("Could not get 2d canvas context!");o.drawImage(e,0,0,l,i);const s=o.getImageData(0,0,l,i);return{blurhash:j.encode(s.data,s.width,s.height,4,4),width:e.width,height:e.height}}catch(e){return}finally{window.URL.revokeObjectURL(t)}}var $=a(770);class SimpleStateSubject extends v.BehaviorSubject{constructor(e){super(e)}getSnapshot(){return this.getValue()}setState(e){this.next((0,$.merge)({},this.getSnapshot(),e))}}class UploadState{constructor(e,t,a={allowRepeatedUploads:!1},l=U){(0,y.default)(this,"abort$",new v.Subject),(0,y.default)(this,"files$$",new v.BehaviorSubject([])),(0,y.default)(this,"files$",this.files$$.pipe(v.switchMap((e=>e.length?v.zip(...e):v.of([]))))),(0,y.default)(this,"clear$",new v.Subject),(0,y.default)(this,"error$",new v.BehaviorSubject(void 0)),(0,y.default)(this,"uploading$",new v.BehaviorSubject(!1)),(0,y.default)(this,"done$",new v.Subject),(0,y.default)(this,"subscriptions",void 0),(0,y.default)(this,"validateFile",(e=>{const t=this.fileKind;if(null!=t.maxSizeBytes&&e.size>this.fileKind.maxSizeBytes){const e=p.fileTooLarge(String(this.fileKind.maxSizeBytes));throw new Error(e)}if(null!=t.allowedMimeTypes&&!t.allowedMimeTypes.includes(e.type)){const a=p.mimeTypeNotSupported(e.type,t.allowedMimeTypes.join(", "));throw new Error(a)}})),(0,y.default)(this,"setFiles",(e=>{if(this.isUploading())throw new Error("Cannot update files while uploading");let t;e.length||(this.done$.next(void 0),this.error$.next(void 0));try{e.forEach(this.validateFile)}catch(e){t=e}this.files$$.next(e.map((e=>new SimpleStateSubject({file:e,status:"idle",error:t}))))})),(0,y.default)(this,"abort",(()=>{if(!this.isUploading())throw new Error("No upload in progress");this.abort$.next()})),(0,y.default)(this,"clear",(()=>{this.setFiles([]),this.clear$.next()})),(0,y.default)(this,"uploadFile",((e,t,a)=>{const l=new AbortController,i=l.signal,{file:o,status:s,error:r}=e.getValue();if(r&&"idle"===s)return v.of(void 0);if(!["idle","upload_failed"].includes(s))return v.of(void 0);let n;e.setState({status:"uploading",error:void 0});const{name:d}={name:((u=o.name).substring(0,u.lastIndexOf("."))||u).trim().slice(0,256).replace(/[^a-z0-9\s]/gi,"_")};var u;const c=o.type||void 0,h=a;return v.from(function(e){var t;return Boolean(null===(t=e.type)||void 0===t?void 0:t.startsWith("image/"))}(o)?this.loadImageMetadata(o):v.of(void 0)).pipe(v.mergeMap((e=>this.client.create({kind:this.fileKind.id,name:d,mimeType:c,meta:e?{...e,...h}:h}))),v.mergeMap((e=>(n=e.file,v.race(t.pipe(v.map((()=>{throw l.abort(),new Error("Abort!")}))),this.client.upload({body:o,id:n.id,kind:this.fileKind.id,abortSignal:i,selfDestructOnAbort:!0,contentType:c}))))),v.map((()=>{var t;e.setState({status:"uploaded",id:null===(t=n)||void 0===t?void 0:t.id,fileJSON:n})})),v.catchError((t=>{const a="Abort!"===t.message;return e.setState({status:"upload_failed",error:a?void 0:t}),v.of(a?void 0:t)})))})),(0,y.default)(this,"upload",(e=>{if(this.isUploading())throw new Error("Upload already in progress");const t=new v.ReplaySubject(1),a=this.abort$.subscribe(t),l=this.files$$.pipe(v.take(1),v.switchMap((a=>v.forkJoin(a.map((a=>this.uploadFile(a,t,e)))))),v.map((()=>{})),v.finalize((()=>{this.opts.allowRepeatedUploads&&this.clear(),a.unsubscribe()})),v.shareReplay());return l.subscribe(),l})),(0,y.default)(this,"dispose",(()=>{for(const e of this.subscriptions)e.unsubscribe()})),this.fileKind=e,this.client=t,this.opts=a,this.loadImageMetadata=l;const i=this.files$$.pipe(v.switchMap((e=>v.combineLatest(e))));this.subscriptions=[i.pipe(v.map((e=>e.some((e=>"uploading"===e.status)))),v.distinctUntilChanged()).subscribe(this.uploading$),i.pipe(v.map((e=>{const t=e.find((e=>Boolean(e.error)));return t?t.error:void 0})),v.filter(Boolean)).subscribe(this.error$),i.pipe(v.filter((e=>Boolean(e.length)&&e.every((e=>"uploaded"===e.status)))),v.map((e=>e.map((e=>({id:e.id,kind:this.fileKind.id,fileJSON:e.fileJSON})))))).subscribe(this.done$)]}isUploading(){return this.uploading$.getValue()}hasFiles(){return this.files$$.getValue().length>0}}const S=({meta:e,onDone:t,onError:a,fullWidth:i,allowClear:r,onUploadEnd:n,onUploadStart:d,compressed:c=!1,kind:h,multiple:p=!1,initialPromptText:f,immediate:m=!1,allowRepeatedUploads:g=!1,className:b})=>{var w;const{client:M}=(0,o.A)(),y=(0,l.useRef)(null),v=M.getFileKind(h),j=c||g,U=(0,l.useMemo)((()=>(({fileKind:e,client:t,imageMetadataFactory:a,...l})=>new UploadState(e,t,l,a))({client:M,fileKind:v,allowRepeatedUploads:j})),[M,j,v]);return(0,l.useEffect)((()=>{const e=[U.clear$.subscribe((()=>{var e;null===(e=y.current)||void 0===e||e.removeFiles()})),U.done$.subscribe((e=>e&&t(e))),U.error$.subscribe((e=>e&&(null==a?void 0:a(e)))),U.uploading$.subscribe((e=>e?null==d?void 0:d():null==n?void 0:n()))];return()=>e.forEach((e=>e.unsubscribe()))}),[U,t,a,d,n]),(0,l.useEffect)((()=>U.dispose),[U]),(0,s.jsx)(u.Provider,{value:U},(0,s.jsx)(x,{compressed:c,ref:y,accept:null===(w=v.allowedMimeTypes)||void 0===w?void 0:w.join(","),meta:e,immediate:c||m,allowClear:r,fullWidth:i,initialFilePromptText:f,multiple:p,className:b}))},k=S},7769:e=>{var t,a=Object.defineProperty,l=Object.getOwnPropertyDescriptor,i=Object.getOwnPropertyNames,o=Object.prototype.hasOwnProperty,s={};((e,t)=>{for(var l in t)a(e,l,{get:t[l],enumerable:!0})})(s,{ValidationError:()=>p,decode:()=>w,encode:()=>x,isBlurhashValid:()=>m}),e.exports=(t=s,((e,t,s,r)=>{if(t&&"object"==typeof t||"function"==typeof t)for(let s of i(t))!o.call(e,s)&&undefined!==s&&a(e,s,{get:()=>t[s],enumerable:!(r=l(t,s))||r.enumerable});return e})(a({},"__esModule",{value:!0}),t));var r=["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","#","$","%","*","+",",","-",".",":",";","=","?","@","[","]","^","_","{","|","}","~"],n=e=>{let t=0;for(let a=0;a<e.length;a++){let l=e[a];t=83*t+r.indexOf(l)}return t},d=(e,t)=>{var a="";for(let l=1;l<=t;l++){let i=Math.floor(e)/Math.pow(83,t-l)%83;a+=r[Math.floor(i)]}return a},u=e=>{let t=e/255;return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)},c=e=>{let t=Math.max(0,Math.min(1,e));return t<=.0031308?Math.trunc(12.92*t*255+.5):Math.trunc(255*(1.055*Math.pow(t,.4166666666666667)-.055)+.5)},h=(e,t)=>(e=>e<0?-1:1)(e)*Math.pow(Math.abs(e),t),p=class extends Error{constructor(e){super(e),this.name="ValidationError",this.message=e}},f=e=>{if(!e||e.length<6)throw new p("The blurhash string must be at least 6 characters");let t=n(e[0]),a=Math.floor(t/9)+1,l=t%9+1;if(e.length!==4+2*l*a)throw new p(`blurhash length mismatch: length is ${e.length} but it should be ${4+2*l*a}`)},m=e=>{try{f(e)}catch(e){return{result:!1,errorReason:e.message}}return{result:!0}},g=e=>{let t=e>>8&255,a=255&e;return[u(e>>16),u(t),u(a)]},b=(e,t)=>{let a=Math.floor(e/361),l=Math.floor(e/19)%19,i=e%19;return[h((a-9)/9,2)*t,h((l-9)/9,2)*t,h((i-9)/9,2)*t]},w=(e,t,a,l)=>{f(e),l|=1;let i=n(e[0]),o=Math.floor(i/9)+1,s=i%9+1,r=(n(e[1])+1)/166,d=new Array(s*o);for(let t=0;t<d.length;t++)if(0===t){let a=n(e.substring(2,6));d[t]=g(a)}else{let a=n(e.substring(4+2*t,6+2*t));d[t]=b(a,r*l)}let u=4*t,h=new Uint8ClampedArray(u*a);for(let e=0;e<a;e++)for(let l=0;l<t;l++){let i=0,r=0,n=0;for(let u=0;u<o;u++)for(let o=0;o<s;o++){let c=Math.cos(Math.PI*l*o/t)*Math.cos(Math.PI*e*u/a),h=d[o+u*s];i+=h[0]*c,r+=h[1]*c,n+=h[2]*c}let p=c(i),f=c(r),m=c(n);h[4*l+0+e*u]=p,h[4*l+1+e*u]=f,h[4*l+2+e*u]=m,h[4*l+3+e*u]=255}return h},M=(e,t,a,l)=>{let i=0,o=0,s=0,r=4*t;for(let n=0;n<t;n++){let t=4*n;for(let d=0;d<a;d++){let a=t+d*r,c=l(n,d);i+=c*u(e[a]),o+=c*u(e[a+1]),s+=c*u(e[a+2])}}let n=1/(t*a);return[i*n,o*n,s*n]},x=(e,t,a,l,i)=>{if(l<1||l>9||i<1||i>9)throw new p("BlurHash must have between 1 and 9 components");if(t*a*4!==e.length)throw new p("Width and height must match the pixels array");let o=[];for(let s=0;s<i;s++)for(let i=0;i<l;i++){let l=0==i&&0==s?1:2,r=M(e,t,a,((e,o)=>l*Math.cos(Math.PI*i*e/t)*Math.cos(Math.PI*s*o/a)));o.push(r)}let s,r=o[0],n=o.slice(1),u="";if(u+=d(l-1+9*(i-1),1),n.length>0){let e=Math.max(...n.map((e=>Math.max(...e)))),t=Math.floor(Math.max(0,Math.min(82,Math.floor(166*e-.5))));s=(t+1)/166,u+=d(t,1)}else s=1,u+=d(0,1);return u+=d((e=>(c(e[0])<<16)+(c(e[1])<<8)+c(e[2]))(r),4),n.forEach((e=>{u+=d(((e,t)=>19*Math.floor(Math.max(0,Math.min(18,Math.floor(9*h(e[0]/t,.5)+9.5))))*19+19*Math.floor(Math.max(0,Math.min(18,Math.floor(9*h(e[1]/t,.5)+9.5))))+Math.floor(Math.max(0,Math.min(18,Math.floor(9*h(e[2]/t,.5)+9.5)))))(e,s),2)})),u}}}]);