"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  registerConnectorTypes: true,
  casesConnectors: true
};
Object.defineProperty(exports, "casesConnectors", {
  enumerable: true,
  get: function () {
    return _factory.casesConnectors;
  }
});
exports.registerConnectorTypes = registerConnectorTypes;
var _server = require("@kbn/core/server");
var _cases = require("./cases");
var _types = require("./types");
Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});
var _factory = require("./factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerConnectorTypes({
  alerting,
  actions,
  core,
  getCasesClient,
  getSpaceId,
  isServerlessSecurity
}) {
  const getUnsecuredSavedObjectsClient = async (request, savedObjectTypes) => {
    const [coreStart] = await core.getStartServices();

    /**
     * The actions framework ensures that the user executing the case action
     * will have permissions to use cases for the corresponding owner and space.
     * The required Kibana privileges needed to execute the case action are defined
     * in x-pack/platform/plugins/shared/cases/server/connectors/cases/index.ts.
     *
     * We can safely disable security checks performed by the saved object client
     * as we implement our custom authorization.
     */
    const unsecuredSavedObjectsClient = coreStart.savedObjects.getScopedClient(request, {
      includedHiddenTypes: savedObjectTypes,
      excludedExtensions: [_server.SECURITY_EXTENSION_ID]
    });
    return unsecuredSavedObjectsClient;
  };
  actions.registerSubActionConnectorType((0, _cases.getCasesConnectorType)({
    getCasesClient,
    getSpaceId,
    getUnsecuredSavedObjectsClient,
    isServerlessSecurity
  }));
  alerting.registerConnectorAdapter((0, _cases.getCasesConnectorAdapter)({
    isServerlessSecurity
  }));
}