"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeveritySelector = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _config = require("./config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SeveritySelector = ({
  selectedSeverity,
  onSeverityChange,
  isLoading,
  isDisabled
}) => {
  const caseSeverities = Object.keys(_config.severities);
  const options = caseSeverities.map(severity => {
    return {
      value: severity,
      inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: 'center',
        responsive: false,
        "data-test-subj": `case-severity-selection-${severity}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_config.SeverityHealth, {
        severity: severity
      })))
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: isDisabled,
    fullWidth: true,
    isLoading: isLoading,
    options: options,
    valueOfSelected: selectedSeverity,
    onChange: onSeverityChange,
    "data-test-subj": "case-severity-selection"
  });
};
exports.SeveritySelector = SeveritySelector;
SeveritySelector.displayName = 'SeveritySelector';