"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.severities = exports.SeverityHealth = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _domain = require("../../../common/types/domain");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const severities = exports.severities = {
  [_domain.CaseSeverity.LOW]: {
    label: _translations.LOW
  },
  [_domain.CaseSeverity.MEDIUM]: {
    label: _translations.MEDIUM
  },
  [_domain.CaseSeverity.HIGH]: {
    label: _translations.HIGH
  },
  [_domain.CaseSeverity.CRITICAL]: {
    label: _translations.CRITICAL
  }
};
const SeverityHealth = ({
  severity
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isAmsterdam = euiTheme.flags.hasVisColorAdjustment;
  const severityData = {
    low: {
      color: isAmsterdam ? euiTheme.colors.vis.euiColorVis0 : euiTheme.colors.vis.euiColorSeverity5,
      label: _translations.LOW
    },
    medium: {
      color: isAmsterdam ? euiTheme.colors.vis.euiColorVis5 : euiTheme.colors.vis.euiColorSeverity7,
      label: _translations.MEDIUM
    },
    high: {
      color: isAmsterdam ? euiTheme.colors.vis.euiColorVis7 : euiTheme.colors.vis.euiColorSeverity10,
      label: _translations.HIGH
    },
    critical: {
      color: isAmsterdam ? euiTheme.colors.vis.euiColorVis9 : euiTheme.colors.vis.euiColorSeverity14,
      label: _translations.CRITICAL
    }
  };
  const {
    color,
    label
  } = severityData[severity];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    "data-test-subj": `case-table-column-severity-${severity}`
  }, label);
};
exports.SeverityHealth = SeverityHealth;
SeverityHealth.displayName = 'SeverityHealth';