"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeHasWorkpadsRoute = initializeHasWorkpadsRoute;
var _constants = require("../../../common/lib/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initializeHasWorkpadsRoute(deps) {
  const {
    router
  } = deps;
  router.versioned.get({
    path: `${_constants.API_ROUTE_WORKPAD}/hasWorkpads`,
    access: 'internal'
  }).addVersion({
    version: '1',
    validate: {
      request: {}
    }
  }, async (context, request, response) => {
    const savedObjectsClient = (await context.core).savedObjects.client;
    try {
      const workpads = await savedObjectsClient.find({
        type: _constants.CANVAS_TYPE,
        fields: ['id'],
        perPage: 1,
        // search across all spaces
        namespaces: ['*']
      });
      return response.ok({
        body: {
          hasWorkpads: workpads.total > 0
        }
      });
    } catch (error) {
      return response.ok({
        body: {
          hasWorkpads: false
        }
      });
    }
  });
}