"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.embeddableRendererFactory = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _rxjs = require("rxjs");
var _lib = require("../../../common/lib");
var _i18n = require("../../../i18n");
var _embeddable_input_to_expression = require("./embeddable_input_to_expression");
var _use_get_app_context = require("./use_get_app_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  embeddable: strings
} = _i18n.RendererStrings;
const children = {};
const renderReactEmbeddable = ({
  type,
  uuid,
  input,
  container,
  handlers,
  core
}) => {
  // wrap in functional component to allow usage of hooks
  const RendererWrapper = () => {
    const getAppContext = (0, _use_get_app_context.useGetAppContext)(core);
    const searchApi = (0, _react.useMemo)(() => {
      return {
        filters$: new _rxjs.BehaviorSubject(input.filters),
        query$: new _rxjs.BehaviorSubject(undefined),
        timeRange$: new _rxjs.BehaviorSubject(undefined)
      };
    }, []);
    return /*#__PURE__*/_react.default.createElement(_public.ReactEmbeddableRenderer, {
      type: type,
      maybeId: uuid,
      getParentApi: () => ({
        ...container,
        getAppContext,
        getSerializedStateForChild: () => ({
          rawState: (0, _lodash.omit)(input, ['disableTriggers', 'filters'])
        }),
        ...searchApi
      }),
      key: `${type}_${uuid}`,
      onAnyStateChange: newState => {
        const newExpression = (0, _embeddable_input_to_expression.embeddableInputToExpression)(newState.rawState, type, undefined, true);
        if (newExpression) handlers.onEmbeddableInputChange(newExpression);
      },
      onApiAvailable: api => {
        children[uuid] = {
          ...api,
          setFilters: filters => {
            if (!(0, _esQuery.onlyDisabledFiltersChanged)(searchApi.filters$.getValue(), filters, {
              ..._esQuery.COMPARE_ALL_OPTIONS,
              // do not compare $state to avoid refreshing when filter is pinned/unpinned (which does not impact results)
              state: false
            })) {
              searchApi.filters$.next(filters);
            }
          }
        };
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement("div", {
    className: _lib.CANVAS_EMBEDDABLE_CLASSNAME,
    style: {
      width: '100%',
      height: '100%',
      cursor: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(RendererWrapper, null)));
};
const embeddableRendererFactory = (core, plugins) => {
  return () => ({
    name: 'embeddable',
    displayName: strings.getDisplayName(),
    help: strings.getHelpDescription(),
    reuseDomNode: true,
    render: async (domNode, {
      input,
      embeddableType,
      canvasApi
    }, handlers) => {
      const uuid = handlers.getElementId();
      const api = children[uuid];
      if (!api) {
        _reactDom.default.render(renderReactEmbeddable({
          input,
          handlers,
          uuid,
          type: embeddableType,
          container: canvasApi,
          core
        }), domNode, () => handlers.done());
        handlers.onDestroy(() => {
          delete children[uuid];
          handlers.onEmbeddableDestroyed();
          return _reactDom.default.unmountComponentAtNode(domNode);
        });
      } else {
        api.setFilters(input.filters);
      }
    }
  });
};
exports.embeddableRendererFactory = embeddableRendererFactory;