"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_kibana = require("../../../../../common/hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRowCss = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react2.css)`
    &.euiPanel:hover,
    &.euiPanel:focus {
      box-shadow: none;
      transform: none;
    }
    &.euiPanel:hover {
      background-color: ${euiTheme.colors.lightestShade};
    }
    .euiRadio {
      color: ${euiTheme.colors.textPrimary};
      label.euiRadio__label {
        padding-left: ${euiTheme.size.xl} !important;
      }
    }
  `;
};
const ConnectorSelector = exports.ConnectorSelector = /*#__PURE__*/_react.default.memo(({
  connectors,
  setConnector,
  selectedConnectorId
}) => {
  const {
    triggersActionsUi: {
      actionTypeRegistry
    }
  } = (0, _use_kibana.useKibana)().services;
  const rowCss = useRowCss();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "stretch",
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "connectorSelector"
  }, connectors.map(connector => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: connector.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    element: "button",
    type: "button" // So that the enter button will not submit the form.
    ,
    role: "radio",
    key: connector.id,
    onClick: () => setConnector(connector),
    hasShadow: false,
    hasBorder: true,
    paddingSize: "l",
    css: rowCss,
    "data-test-subj": `connectorSelector-${connector.id}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    label: connector.name,
    id: connector.id,
    value: connector.id,
    checked: selectedConnectorId === connector.id,
    onChange: () => setConnector(connector),
    "data-test-subj": `connectorSelectorRadio-${connector.id}${selectedConnectorId === connector.id ? '-selected' : ''}`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, actionTypeRegistry.get(connector.actionTypeId).actionTypeTitle))))))));
});
ConnectorSelector.displayName = 'ConnectorSelector';