/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.apm_bundle_jsonpfunction=self.apm_bundle_jsonpfunction||[]).push([[1514],{21514:(e,a,n)=>{n.r(a),n.d(a,{Onboarding:()=>ke});var t=n(84286),i=n.n(t),r=n(20409),o=n(81319),s=n(12965),l=n(57991),u=n(75008),c=n(75879),p=n(52475),d=n(96791);function g({isBeta:e,guideLink:a}){const n=(0,d.jsx)(o.EuiBetaBadge,{label:u.i18n.translate("xpack.apm.onboarding.betaLabel",{defaultMessage:"Beta"})}),t=(0,p.D)("/plugins/apm/assets/apm.png"),r=[(0,d.jsx)(o.EuiImage,{size:"l",allowFullScreen:!0,fullScreenIconColor:"dark",alt:u.i18n.translate("xpack.apm.onboarding.introduction.imageAltDescription",{defaultMessage:"screenshot of primary dashboard."}),url:t})];return(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiPageHeader,{iconType:"apmApp",pageTitle:(0,d.jsx)(i().Fragment,null,u.i18n.translate("xpack.apm.onboarding.appName",{defaultMessage:"APM"}),e&&(0,d.jsx)(i().Fragment,null," ",n)),description:(0,d.jsx)(o.EuiText,null,(0,d.jsx)(c.FormattedMessage,{id:"xpack.apm.onboarding.specProvider.longDescription",defaultMessage:"Application Performance Monitoring (APM) collects in-depth performance metrics and errors from inside your application. It allows you to monitor the performance of thousands of applications in real time. {learnMoreLink}.",values:{learnMoreLink:(0,d.jsx)(o.EuiLink,{"data-test-subj":"apmIntroductionLearnMoreLink",href:a,"aria-label":u.i18n.translate("xpack.apm.onboarding.specProvider.learnMoreAriaLabel",{defaultMessage:"Learn more about APM"}),target:"_blank"},u.i18n.translate("xpack.apm.onboarding.specProvider.learnMoreLabel",{defaultMessage:"Learn more"}))}})),rightSideItems:r}))}var m=n(1493),y=n(38498),k=n(88450),f=n(70200);function x({agentTabs:e,selectedTab:a}){const n=(0,m.useHistory)(),{euiTheme:t}=(0,o.useEuiTheme)();return(0,d.jsx)(o.EuiTabs,{css:(0,d.css)("padding:0 ",t.size.l,";","")},e.map((e=>(0,d.jsx)(o.EuiTab,{key:e.id,isSelected:e.id===a,onClick:()=>{return a=e.id,void(0,f.VC)(n,{query:{agent:a}});var a}},e.text))))}function v({instructionVariants:e,selectedTab:a}){const n=e.find((e=>e.id===a));return n?(0,d.jsx)(o.EuiSteps,{titleSize:"xs",steps:n.instructions}):(0,d.jsx)(i().Fragment,null)}function h({instructions:e}){const a=(0,t.useMemo)((()=>e.instructionVariants.map((e=>({id:e.id,text:(0,y.K)(e.id)})))),[e]),{query:{agent:n}}=(0,k.Oh)("/onboarding"),i=null!=n?n:a[0].id;return(0,d.jsx)(o.EuiSplitPanel.Outer,null,(0,d.jsx)(o.EuiSplitPanel.Inner,{color:"subdued",paddingSize:"none"},(0,d.jsx)(x,{agentTabs:a,selectedTab:i})),(0,d.jsx)(o.EuiSplitPanel.Inner,{paddingSize:"l"},(0,d.jsx)(o.EuiTitle,{size:"m"},(0,d.jsx)("h2",null,e.title)),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(v,{instructionVariants:e.instructionVariants,selectedTab:i})))}var E=n(87677),A=n.n(E);const S=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.serviceNameHint",{defaultMessage:"The service name is the primary filter in the APM UI and is used to group errors and trace data together. Allowed characters are a-z, A-Z, 0-9, -, _, and space."}),b=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.secretTokenHint",{defaultMessage:"Use if APM Server requires a secret token. Both the agent and APM Server must be configured with the same token. This ensures that only your agents can send data to your APM server."}),M=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.apiKeyHint",{defaultMessage:"Use if APM Server requires an API Key. This is used to ensure that only your agents can send data to your APM server. Agents can use API keys as a replacement of secret token, APM server can have multiple API keys. When both secret token and API key are used, API key has priority and secret token is ignored."}),j=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.serverUrlHint",{defaultMessage:"Set the custom APM Server URL (default: {defaultApmServerUrl}). The URL must be fully qualified, including protocol (http or https) and port.",values:{defaultApmServerUrl:"http://localhost:8200"}}),T=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.serviceEnvironmentHint",{defaultMessage:'The name of the environment this service is deployed in, e.g., "production" or "staging". Environments allow you to easily filter data on a global level in the APM UI. It\'s important to be consistent when naming environments across agents.'}),K=e=>({...e&&{secretToken:"elastic.apm.secret_token"},...!e&&{apiKey:"elastic.apm.api_key"},apmServerUrl:"elastic.apm.server_url"}),C=e=>({start:1,highlight:"",annotations:{2:S,3:e?M:b,4:j,5:T}}),L=e=>({...e&&{secretToken:"secretToken"},...!e&&{apiKey:"apiKey"},apmServerUrl:"serverUrl"}),P=`// ${u.i18n.translate("xpack.apm.onboarding.nodeClient.configure.commands.addThisToTheFileTopComment",{defaultMessage:"Add this to the very top of the first file loaded in your app"})}\nvar apm = require('elastic-apm-node').start({\n  // {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.nodeClient.createConfig.commands.serviceName",{defaultMessage:"Overrides the service name in package.json."})}\n  serviceName: '<your-service-name>',\n\n  {{^secretToken}}\n  // {{apiKeyHint}}\n  apiKey: '{{{apiKey}}}',\n  {{/secretToken}}\n  {{#secretToken}}\n  // {{secretTokenHint}}\n  secretToken: '{{{secretToken}}}',\n  {{/secretToken}}\n\n  // {{{serverUrlHint}}}\n  serverUrl: '{{{apmServerUrl}}}',\n\n  // {{{serviceEnvironmentHint}}}\n  environment: '<your-environment>'\n})`,_=e=>({...e&&{secretToken:"SECRET_TOKEN"},...!e&&{apiKey:"API_KEY"},apmServerUrl:"SERVER_URL"}),w=`INSTALLED_APPS = (\n  # ${u.i18n.translate("xpack.apm.onboarding.djangoClient.configure.commands.addAgentComment",{defaultMessage:"Add the agent to installed apps"})}\n  'elasticapm.contrib.django',\n  # ...\n)\n\nELASTIC_APM = {\n  # {{serviceNameHint}}\n  'SERVICE_NAME': '<your-service-name>',\n\n  {{^secretToken}}\n  # {{apiKeyHint}}\n  'API_KEY': '{{{apiKey}}}',\n  {{/secretToken}}\n  {{#secretToken}}\n  # {{secretTokenHint}}\n  'SECRET_TOKEN': '{{{secretToken}}}',\n  {{/secretToken}}\n\n  # {{{serverUrlHint}}}\n  'SERVER_URL': '{{{apmServerUrl}}}',\n\n  # {{{serviceEnvironmentHint}}}\n  'ENVIRONMENT': '<your-environment>',\n}\n\nMIDDLEWARE = (\n  # ${u.i18n.translate("xpack.apm.onboarding.djangoClient.configure.commands.addTracingMiddlewareComment",{defaultMessage:"Add our tracing middleware to send performance metrics"})}\n  'elasticapm.contrib.django.middleware.TracingMiddleware',\n  #...\n)`,I=e=>({...e&&{secretToken:"SECRET_TOKEN"},...!e&&{apiKey:"API_KEY"},apmServerUrl:"SERVER_URL"}),F=`# ${u.i18n.translate("xpack.apm.onboarding.flaskClient.configure.commands.initializeUsingEnvironmentVariablesComment",{defaultMessage:"Initialize using environment variables"})}\nfrom elasticapm.contrib.flask import ElasticAPM\napp = Flask(__name__)\napm = ElasticAPM(app)\n\n# ${u.i18n.translate("xpack.apm.onboarding.flaskClient.configure.commands.configureElasticApmComment",{defaultMessage:"Or use ELASTIC_APM in your application's settings"})}\nfrom elasticapm.contrib.flask import ElasticAPM\napp.config['ELASTIC_APM'] = {\n  # {{serviceNameHint}}\n  'SERVICE_NAME': '<your-service-name>',\n  {{^secretToken}}\n  # {{apiKeyHint}}\n  'API_KEY': '{{{apiKey}}}',\n  {{/secretToken}}\n  {{#secretToken}}\n  # {{secretTokenHint}}\n  'SECRET_TOKEN': '{{{secretToken}}}',\n  {{/secretToken}}\n\n  # {{{serverUrlHint}}}\n  'SERVER_URL': '{{{apmServerUrl}}}',\n\n  # {{{serviceEnvironmentHint}}}\n  'ENVIRONMENT': '<your-environment>',\n}\n\napm = ElasticAPM(app)`,U=e=>({...e&&{secretToken:"secret_token"},...!e&&{apiKey:"api_key"},apmServerUrl:"server_url"}),O=`# config/elastic_apm.yml:\n\n# {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.railsClient.createConfig.commands.defaultServiceName",{defaultMessage:"Defaults to the name of your Rails app."})}\nservice_name: '<your-service-name>'\n\n{{^secretToken}}\n# {{apiKeyHint}}\napi_key: '{{{apiKey}}}'\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nsecret_token: '{{{secretToken}}}'\n{{/secretToken}}\n\n# {{{serverUrlHint}}}\nserver_url: '{{{apmServerUrl}}}'\n\n# {{{serviceEnvironmentHint}}}\nenvironment: '<your-environment>'`,R=e=>({...e&&{secretToken:"secret_token"},...!e&&{apiKey:"api_key"},apmServerUrl:"server_url"}),N=`# config/elastic_apm.yml:\n\n# {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.rackClient.createConfig.commands.defaultsToTheNameOfRackAppClassComment",{defaultMessage:"Defaults to the name of your Rack app's class."})}\nservice_name: '<your-service-name>'\n\n{{^secretToken}}\n# {{apiKeyHint}}\napi_key: '{{{apiKey}}}'\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nsecret_token: '{{{secretToken}}}'\n{{/secretToken}}\n\n# {{{serverUrlHint}}}\nserver_url: '{{{apmServerUrl}}}'\n\n# {{{serviceEnvironmentHint}}}\nenvironment: '<your-environment>'`,H=e=>({...e&&{secretToken:"ELASTIC_APM_SECRET_TOKEN"},...!e&&{apiKey:"ELASTIC_APM_API_KEY"},apmServerUrl:"ELASTIC_APM_SERVER_URL"}),D=`# ${u.i18n.translate("xpack.apm.onboarding.goClient.configure.commands.initializeUsingEnvironmentVariablesComment",{defaultMessage:"Initialize using environment variables:"})}\n\n# {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.goClient.configure.commands.usedExecutableNameComment",{defaultMessage:"If not specified, the executable name will be used."})}\nexport ELASTIC_APM_SERVICE_NAME=<your-service-name>\n\n{{^secretToken}}\n# {{apiKeyHint}}\nexport ELASTIC_APM_API_KEY={{{apiKey}}}\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nexport ELASTIC_APM_SECRET_TOKEN={{{secretToken}}}\n{{/secretToken}}\n\n# {{{serverUrlHint}}}\nexport ELASTIC_APM_SERVER_URL={{{apmServerUrl}}}\n\n# {{{serviceEnvironmentHint}}}\nexport ELASTIC_APM_ENVIRONMENT=<your-environment>\n`,B=e=>({...e&&{secretToken:"SecretToken"},...!e&&{apiKey:"ApiKey"},apmServerUrl:"ServerUrl"}),$=`{\n  "ElasticApm": {\n    /// {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.dotnetClient.createConfig.commands.defaultServiceName",{defaultMessage:"Default is the entry assembly of the application."})}\n    "ServiceName": "<your-service-name>",\n    {{^secretToken}}\n    /// {{apiKeyHint}}\n    "ApiKey": "{{{apiKey}}}",\n    {{/secretToken}}\n    {{#secretToken}}\n    /// {{secretTokenHint}}\n    "SecretToken": "{{{secretToken}}}",\n    {{/secretToken}}\n    /// {{{serverUrlHint}}}\n    "ServerUrl": "{{{apmServerUrl}}}",\n    /// {{{serviceEnvironmentHint}}}\n    "Environment": "<your-environment>",\n  }\n}`,V=e=>({...e&&{secretToken:"elastic_apm.secret_token"},...!e&&{apiKey:"elastic_apm.api_key"},apmServerUrl:"elastic_apm.server_url"}),X={java:"java -javaagent:/path/to/elastic-apm-agent-<version>.jar \\\n-Delastic.apm.service_name=<your-service-name> \\\n{{^secretToken}}\n-Delastic.apm.api_key={{{apiKey}}} \\\n{{/secretToken}}\n{{#secretToken}}\n-Delastic.apm.secret_token={{{secretToken}}} \\\n{{/secretToken}}\n-Delastic.apm.server_url={{{apmServerUrl}}} \\\n-Delastic.apm.environment=<your-environment> \\\n-Delastic.apm.application_packages=org.example \\\n-jar my-service-name.jar",node:P,django:w,flask:F,rails:O,rack:N,go:D,dotnet:$,php:'# {{serviceNameHint}}\nelastic_apm.service_name="<your-service-name>"\n\n{{^secretToken}}\n# {{apiKeyHint}}\nelastic_apm.api_key="{{{apiKey}}}"\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nelastic_apm.secret_token="{{{secretToken}}}"\n{{/secretToken}}\n\n# {{serverUrlHint}}\nelastic_apm.server_url="{{{apmServerUrl}}}"\n\n# {{{serviceEnvironmentHint}}}\nelastic_apm.environment="<your-environment>"'},G={java:"java",node:"js",django:"py",flask:"py",rails:"rb",rack:"rb",go:"go",dotnet:"dotnet",php:"php"};var z=n(30770);function q({columnKey:e,value:a,createApiKey:n,createApiKeyLoading:t}){return"apiKey"===e&&null===a?(0,d.jsx)(o.EuiButton,{"data-test-subj":"createApiKeyAndId",fill:!0,onClick:n,isLoading:t},u.i18n.translate("xpack.apm.tutorial.apiKey.create",{defaultMessage:"Create API Key"})):(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiText,{size:"s",color:"accent"},a),a&&(0,d.jsx)(o.EuiButtonIcon,{"data-test-subj":"apmConfigurationValueColumnButton","aria-label":u.i18n.translate("xpack.apm.onboarding.column.value.copyIconText",{defaultMessage:"Copy to clipboard"}),color:"text",iconType:"copy",onClick:()=>(0,o.copyToClipboard)(a)}))}function W({variables:e,data:a,createApiKey:n,createApiKeyLoading:t}){if(!e)return null;const i={apmServiceName:"my-service-name",apmEnvironment:"my-environment"},r=[{field:"setting",name:u.i18n.translate("xpack.apm.onboarding.agent.column.configSettings",{defaultMessage:"Configuration setting"})},{field:"value",name:u.i18n.translate("xpack.apm.onboarding.agent.column.configValue",{defaultMessage:"Configuration value"}),render:(e,{value:a,key:i})=>(0,d.jsx)(q,{columnKey:i,value:a,createApiKey:n,createApiKeyLoading:t})}],s=Object.entries(e).map((([e,n])=>({setting:n,value:(0,z.get)({...a,...i},e),key:e})));return(0,d.jsx)(o.EuiBasicTable,{items:s,columns:r})}function Y({variantId:e,apmServerUrl:a,secretToken:n,apiKey:t,createApiKey:r,createApiKeyLoading:s}){const l=function({variantId:e,apmServerUrl:a,secretToken:n,apiKey:t}){const i=X[e];return i?A().render(i,{apmServerUrl:a,secretToken:n,apiKey:t,serviceNameHint:S,serviceEnvironmentHint:T,serverUrlHint:j,secretTokenHint:b,apiKeyHint:M}):""}({variantId:e,apmServerUrl:a,secretToken:n,apiKey:t}),c=function(e,a){return(e=>({java:K(e),node:L(e),django:_(e),flask:I(e),rails:U(e),rack:R(e),go:H(e),dotnet:B(e),php:V(e)}))(a)[e]}(e,n),p=function(e,a){return(e=>({java:C(e),node:{start:1,highlight:"2, 4, 7, 10, 13-14"},django:{start:1,highlight:"1, 3, 5, 7, 9, 12, 15, 18-19, 21, 23, 25"},flask:{start:1,highlight:"2-4, 7-8, 10, 12, 15, 18-21"},rails:{start:1,highlight:"4, 7, 10, 13"},rack:{start:1,highlight:"4, 7, 10, 13"},go:{start:1,highlight:"4, 7, 10, 13"},dotnet:{start:1,highlight:"1-2, 4, 6, 8, 10-12"},php:{start:1,highlight:"2, 5, 8, 11"}}))(a)[e]}(e,t),g=function(e){return G[e]}(e);return(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(W,{variables:c,data:{apmServerUrl:a,secretToken:n,apiKey:t},createApiKey:r,createApiKeyLoading:s}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiCodeBlock,{isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.agentConfigInstructions.euiCodeBlock.copyAriaLabel",{defaultMessage:"Copy {variantId} agent configuration code",values:{variantId:e}}),language:g||"bash","data-test-subj":"commands",lineNumbers:p,whiteSpace:"pre"},l))}function J({isSuccess:e,isError:a,errorMessage:n}){return e?(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiCallOut,{title:u.i18n.translate("xpack.apm.onboarding.apiKey.success.calloutTitle",{defaultMessage:"API key created"}),color:"success",iconType:"check","data-test-subj":"apiKeySuccessCallout"},u.i18n.translate("xpack.apm.onboarding.apiKey.success.calloutMessage",{defaultMessage:"Remember to store this information in a safe place. It won't be displayed anymore after you continue"}))):a&&/missing the following requested privilege\(s\)/.test(n||"")?(0,d.jsx)(o.EuiCallOut,{title:u.i18n.translate("xpack.apm.onboarding.apiKey.warning.calloutTitle",{defaultMessage:"User does not have permissions to create API Key"}),color:"warning",iconType:"warning","data-test-subj":"apiKeyWarningCallout"},u.i18n.translate("xpack.apm.onboarding.apiKey.warning.calloutMessage",{defaultMessage:"User is missing the following privilege - {missingPrivilege}. Please add the missing APM application privilege to the role of the authenticated user",values:{missingPrivilege:"event:write"}})):(0,d.jsx)(o.EuiCallOut,{title:u.i18n.translate("xpack.apm.onboarding.apiKey.error.calloutTitle",{defaultMessage:"Failed to create API key"}),color:"danger",iconType:"error","data-test-subj":"apiKeyErrorCallout"},u.i18n.translate("xpack.apm.onboarding.apiKey.error.calloutMessage",{defaultMessage:"Error: {errorMessage}",values:{errorMessage:n}}))}function Z(){return(0,d.jsx)(o.EuiCallOut,{color:"warning","data-test-subj":"agentStatusWarningCallout"},u.i18n.translate("xpack.apm.onboarding.agentStatus.warning.calloutMessage",{defaultMessage:"No data has been received from agents yet"}))}function Q(){return(0,d.jsx)(o.EuiCallOut,{color:"success","data-test-subj":"agentStatusSuccessCallout"},u.i18n.translate("xpack.apm.onboarding.agentStatus.success.calloutMessage",{defaultMessage:"Data successfully received from one or more agents"}))}function ee({checkAgentStatus:e,agentStatus:a,agentStatusLoading:n}){let t="incomplete",r=(0,d.jsx)(i().Fragment,null);return!1===a&&(t="warning",r=(0,d.jsx)(Z,null)),a&&(t="complete",r=(0,d.jsx)(Q,null)),{title:u.i18n.translate("xpack.apm.onboarding.agentStatusCheck.title",{defaultMessage:"Agent status"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.agentStatusCheck.textPre",{defaultMessage:"Make sure your application is running and the agents are sending data."})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiButton,{"data-test-subj":"checkAgentStatus",onClick:e,isLoading:n},u.i18n.translate("xpack.apm.onboarding.agentStatus.check",{defaultMessage:"Check Agent Status"})),(0,d.jsx)(o.EuiSpacer,null),r),status:t}}const ae=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:s,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.java.download.title",{defaultMessage:"Download the APM agent"}),children:(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.java.download.textPre",{defaultMessage:"Download the agent jar from [Maven Central]({mavenCentralLink}).       Do **not** add the agent as a dependency to your application.",values:{mavenCentralLink:"https://oss.sonatype.org/service/local/artifact/maven/redirect?r=releases&g=co.elastic.apm&a=elastic-apm-agent&v=LATEST"}}))},{title:u.i18n.translate("xpack.apm.onboarding.java.startApplication.title",{defaultMessage:"Start your application with the javaagent flag"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.java.startApplication.textPre",{defaultMessage:"Add the `-javaagent` flag and configure the agent with system properties.\n\n * Set the required service name (allowed characters: a-z, A-Z, 0-9, -, _, and space)\n * Set the custom APM Server URL (default: {customApmServerUrl})\n * Set the APM Server secret token\n * Set the service environment\n * Set the base package of your application",values:{customApmServerUrl:"http://localhost:8200"}})),(0,d.jsx)(o.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(J,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(o.EuiSpacer,null)),(0,d.jsx)(Y,{variantId:y.X.JAVA,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.java.startApplication.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced         usage.",values:{documentationLink:`${a}guide/en/apm/agent/java/current/index.html`}})))},ee({checkAgentStatus:r,agentStatus:s,agentStatusLoading:l})]},ne=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:s,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.node.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.node.install.textPre",{defaultMessage:"Install the APM agent for Node.js as a dependency to your application."})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.node.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Node.js"})},"npm install elastic-apm-node --save"))},{title:u.i18n.translate("xpack.apm.onboarding.node.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.node.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process.  APM services are created programmatically based on the `serviceName`.  This agent supports a variety of frameworks but can also be used with your custom stack."})),(0,d.jsx)(o.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(J,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(o.EuiSpacer,null)),(0,d.jsx)(Y,{variantId:y.X.NODE,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.node.configure.textPost",{defaultMessage:"See [the documentation]({documentationLink}) for advanced usage, including how to use with [Babel/ES Modules]({babelEsModulesLink}).",values:{documentationLink:`${a}guide/en/apm/agent/nodejs/current/index.html`,babelEsModulesLink:`${a}guide/en/apm/agent/nodejs/current/advanced-setup.html#es-modules`}})))},ee({checkAgentStatus:r,agentStatus:s,agentStatusLoading:l})]},te=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:s,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.django.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.django.install.textPre",{defaultMessage:"Install the APM agent for Python as a dependency."})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.django.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Django"})},"$ pip install elastic-apm"))},{title:u.i18n.translate("xpack.apm.onboarding.django.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.django.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process. APM services are created programmatically based on the `SERVICE_NAME`."})),(0,d.jsx)(o.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(J,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(o.EuiSpacer,null)),(0,d.jsx)(Y,{variantId:y.X.DJANGO,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.django.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for advanced usage.",values:{documentationLink:`${a}guide/en/apm/agent/python/current/django-support.html`}})))},ee({checkAgentStatus:r,agentStatus:s,agentStatusLoading:l})]},ie=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:s,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.flask.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.flask.install.textPre",{defaultMessage:"Install the APM agent for Python as a dependency."})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.flask.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Flask"})},"$ pip install elastic-apm[flask]"))},{title:u.i18n.translate("xpack.apm.onboarding.flask.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.flask.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process. APM services are created programmatically based on the `SERVICE_NAME`."})),(0,d.jsx)(o.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(J,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(o.EuiSpacer,null)),(0,d.jsx)(Y,{variantId:y.X.FLASK,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.flask.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for advanced usage.",values:{documentationLink:`${a}guide/en/apm/agent/python/current/flask-support.html`}})))},ee({checkAgentStatus:r,agentStatus:s,agentStatusLoading:l})]},re=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:s,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.rails.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rails.install.textPre",{defaultMessage:"Add the agent to your Gemfile."})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.rails.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Ruby on Rails"})},"gem 'elastic-apm'"))},{title:u.i18n.translate("xpack.apm.onboarding.rails.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rails.configure.textPre",{defaultMessage:"APM is automatically started when your app boots. Configure the agent, by creating the config file {configFile}",values:{configFile:"`config/elastic_apm.yml`"}})),(0,d.jsx)(o.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(J,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(o.EuiSpacer,null)),(0,d.jsx)(Y,{variantId:y.X.RAILS,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rails.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/agent/ruby/current/index.html`}})))},ee({checkAgentStatus:r,agentStatus:s,agentStatusLoading:l})]},oe=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:s,agentStatusLoading:l}=e,c=`# config.ru\n  require 'sinatra/base'\n\n  class MySinatraApp < Sinatra::Base\n    use ElasticAPM::Middleware\n\n    # ...\n  end\n\n  ElasticAPM.start(\n    app: MySinatraApp, # ${u.i18n.translate("xpack.apm.onboarding.rack.configure.commands.requiredComment",{defaultMessage:"required"})}\n    config_file: '' # ${u.i18n.translate("xpack.apm.onboarding.rack.configure.commands.optionalComment",{defaultMessage:"optional, defaults to config/elastic_apm.yml"})}\n  )\n\n  run MySinatraApp\n\n  at_exit { ElasticAPM.stop }`;return[{title:u.i18n.translate("xpack.apm.onboarding.rack.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rack.install.textPre",{defaultMessage:"Add the agent to your Gemfile."})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.rack.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Rack"})},"gem 'elastic-apm'"))},{title:u.i18n.translate("xpack.apm.onboarding.rack.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rack.configure.textPre",{defaultMessage:"For Rack or a compatible framework (e.g. Sinatra), include the middleware in your app and start the agent."})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.rack.configure.copyAriaLabel",{defaultMessage:"Copy the code to configure the APM agent for Rack"})},c))},{title:u.i18n.translate("xpack.apm.onboarding.rack.createConfig.title",{defaultMessage:"Create config file"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rack.createConfig.textPre",{defaultMessage:"Create a config file {configFile}:",values:{configFile:"`config/elastic_apm.yml`"}})),(0,d.jsx)(o.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(J,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(o.EuiSpacer,null)),(0,d.jsx)(Y,{variantId:y.X.RACK,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rack.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/agent/ruby/current/index.html`}})))},ee({checkAgentStatus:r,agentStatus:s,agentStatusLoading:l})]},se=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:s,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.go.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.install.textPre",{defaultMessage:"Install the APM agent packages for Go."})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.go.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Go"})},"go get go.elastic.co/apm"))},{title:u.i18n.translate("xpack.apm.onboarding.go.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process. APM services are created programmatically based on the executable file name, or the `ELASTIC_APM_SERVICE_NAME` environment variable."})),(0,d.jsx)(o.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(J,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(o.EuiSpacer,null)),(0,d.jsx)(Y,{variantId:y.X.GO,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for advanced configuration.",values:{documentationLink:`${a}guide/en/apm/agent/go/current/configuration.html`}})))},{title:u.i18n.translate("xpack.apm.onboarding.go.goClient.title",{defaultMessage:"Instrument your application"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.instrument.textPre",{defaultMessage:"Instrument your Go application by using one of the provided instrumentation modules or by using the tracer API directly."})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiCodeBlock,{language:"go",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.go.instrument.copyAriaLabel",{defaultMessage:"Copy the code to instrument your Go application"})},'import (\n  "net/http"\n\n  "go.elastic.co/apm/module/apmhttp"\n)\n\nfunc main() {\n  mux := http.NewServeMux()\n  ...\n  http.ListenAndServe(":8080", apmhttp.Wrap(mux))\n}\n'),(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.instrument.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for a detailed guide to instrumenting Go source code.",values:{documentationLink:`${a}guide/en/apm/agent/go/current/instrumenting-source.html`}})))},ee({checkAgentStatus:r,agentStatus:s,agentStatusLoading:l})]},le=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:s,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.dotNet.download.title",{defaultMessage:"Download the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.dotNet.download.textPre",{defaultMessage:"Add the the agent package(s) from [NuGet]({allNuGetPackagesLink}) to your .NET application. There are multiple       NuGet packages available for different use cases. \n\nFor an ASP.NET Core application with Entity Framework       Core download the [Elastic.Apm.NetCoreAll]({netCoreAllApmPackageLink}) package. This package will automatically add every       agent component to your application. \n\n In case you would like to minimize the dependencies, you can use the       [Elastic.Apm.AspNetCore]({aspNetCorePackageLink}) package for just       ASP.NET Core monitoring or the [Elastic.Apm.EfCore]({efCorePackageLink}) package for just Entity Framework Core monitoring. \n\n In       case you only want to use the public Agent API for manual instrumentation use the [Elastic.Apm]({elasticApmPackageLink}) package.",values:{allNuGetPackagesLink:"https://www.nuget.org/packages?q=Elastic.apm",netCoreAllApmPackageLink:"https://www.nuget.org/packages/Elastic.Apm.NetCoreAll",aspNetCorePackageLink:"https://www.nuget.org/packages/Elastic.Apm.AspNetCore",efCorePackageLink:"https://www.nuget.org/packages/Elastic.Apm.EntityFrameworkCore",elasticApmPackageLink:"https://www.nuget.org/packages/Elastic.Apm"}})))},{title:u.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.title",{defaultMessage:"Add the agent to the application"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.textPre",{defaultMessage:"In case of ASP.NET Core with the `Elastic.Apm.NetCoreAll` package, call the `UseAllElasticApm`       method in the `Configure` method within the `Startup.cs` file."})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.copyAriaLabel",{defaultMessage:"Copy the code to add the APM agent to the dotnet application"})},"public class Startup\n{\n  public void Configure(IApplicationBuilder app, IHostingEnvironment env)\n  {\n    app.UseAllElasticApm(Configuration);\n    //…rest of the method\n  }\n  //…rest of the class\n}"),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.textPost",{defaultMessage:"Passing an `IConfiguration` instance is optional and by doing so, the agent will read config settings through this       `IConfiguration` instance (e.g. from the `appsettings.json` file)."})))},{title:u.i18n.translate("xpack.apm.onboarding.dotNet.configureAgent.title",{defaultMessage:"Sample appsettings.json file:"}),children:(0,d.jsx)(i().Fragment,null,((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(J,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(o.EuiSpacer,null)),(0,d.jsx)(Y,{variantId:y.X.DOTNET,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.dotNet.configureAgent.textPost",{defaultMessage:"In case you don’t pass an `IConfiguration` instance to the agent (e.g. in case of non ASP.NET Core applications)       you can also configure the agent through environment variables. \n       See [the documentation]({documentationLink}) for advanced usage, including the [Profiler Auto instrumentation]({profilerLink}) quick start.",values:{documentationLink:`${a}guide/en/apm/agent/dotnet/current/configuration.html`,profilerLink:`${a}guide/en/apm/agent/dotnet/current/setup-auto-instrumentation.html#setup-auto-instrumentation`}})))},ee({checkAgentStatus:r,agentStatus:s,agentStatusLoading:l})]},ue=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:s,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.php.download.title",{defaultMessage:"Download the APM agent"}),children:(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.download.textPre",{defaultMessage:"Download the package corresponding to your platform from [GitHub releases]({githubReleasesLink}).",values:{githubReleasesLink:"https://github.com/elastic/apm-agent-php/releases"}}))},{title:u.i18n.translate("xpack.apm.onboarding.php.installPackage.title",{defaultMessage:"Install the downloaded package"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.installPackage.textPre",{defaultMessage:"For example on Alpine Linux using APK package:"})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.php.installPackage.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for PHP"})},"apk add --allow-untrusted <package-file>.apk"),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.installPackage.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for installation commands on other supported platforms and advanced installation.",values:{documentationLink:`${a}guide/en/apm/agent/php/current/setup.html`}})))},{title:u.i18n.translate("xpack.apm.onboarding.php.configureAgent.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.Configure the agent.textPre",{defaultMessage:"APM is automatically started when your app boots. Configure the agent either via `php.ini` file:"})),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(J,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(o.EuiSpacer,null)),(0,d.jsx)(Y,{variantId:y.X.PHP,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.configureAgent.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/agent/php/current/configuration.html`}})))},ee({checkAgentStatus:r,agentStatus:s,agentStatusLoading:l})]},ce=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:s,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.otel.download.title",{defaultMessage:"Download the OpenTelemetry APM Agent or SDK"}),children:(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.otel.download.textPre",{defaultMessage:"See the [OpenTelemetry Instrumentation guides]({openTelemetryInstrumentationLink}) to download the OpenTelemetry Agent or SDK for your language.",values:{openTelemetryInstrumentationLink:"https://opentelemetry.io/docs/instrumentation"}}))},{title:u.i18n.translate("xpack.apm.onboarding.otel.configureAgent.title",{defaultMessage:"Configure OpenTelemetry in your application"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.otel.configureAgent.textPre",{defaultMessage:"Specify the following OpenTelemetry settings as part of the startup of your application. Note that OpenTelemetry SDKs require some bootstrap code in addition to these configuration settings. For more details, see the [Elastic OpenTelemetry documentation]({openTelemetryDocumentationLink}) and the [OpenTelemetry community instrumentation guides]({openTelemetryInstrumentationLink}).",values:{openTelemetryDocumentationLink:`${a}guide/en/apm/guide/current/open-telemetry.html`,openTelemetryInstrumentationLink:"https://opentelemetry.io/docs/instrumentation"}})),(0,d.jsx)(o.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(J,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(o.EuiSpacer,null)),(0,d.jsx)(de,{apmServerUrl:n,apiKeyDetails:t}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.otel.configureAgent.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/guide/current/open-telemetry.html`}})))},ee({checkAgentStatus:r,agentStatus:s,agentStatusLoading:l})]};function pe({setting:e,value:a,createApiKey:n,createApiKeyLoading:t,apiKey:r}){return"OTEL_EXPORTER_OTLP_HEADERS"===e&&null===r?(0,d.jsx)(o.EuiButton,{"data-test-subj":"createApiKeyAndId",fill:!0,onClick:n,isLoading:t},u.i18n.translate("xpack.apm.onboarding.apiKey.create",{defaultMessage:"Create API Key"})):(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiText,{size:"s",color:"accent"},a),a&&(0,d.jsx)(o.EuiButtonIcon,{"data-test-subj":"apmConfigurationValueColumnButton","aria-label":u.i18n.translate("xpack.apm.onboarding.otel.column.value.copyIconText",{defaultMessage:"Copy to clipboard"}),color:"text",iconType:"copy",onClick:()=>(0,o.copyToClipboard)(a)}))}function de({apmServerUrl:e,secretToken:a,apiKeyDetails:n}){let t;t=a?`Authorization=Bearer ${a}`:`Authorization=ApiKey ${null==n?void 0:n.apiKey}`;const r=[{setting:"OTEL_EXPORTER_OTLP_ENDPOINT",value:e||"<apm-server-url>"},{setting:"OTEL_EXPORTER_OTLP_HEADERS",value:t,apiKey:null==n?void 0:n.apiKey},{setting:"OTEL_METRICS_EXPORTER",value:"otlp",notes:"Enable metrics when supported by your OpenTelemetry client."},{setting:"OTEL_LOGS_EXPORTER",value:"otlp",notes:"Enable logs when supported by your OpenTelemetry client"},{setting:"OTEL_RESOURCE_ATTRIBUTES",value:"service.name=<app-name>,service.version=<app-version>,deployment.environment=production"}],s=[{field:"setting",width:"23%",name:u.i18n.translate("xpack.apm.onboarding.config_otel.column.configSettings",{defaultMessage:"Configuration setting (1)"})},{field:"value",width:"55%",name:u.i18n.translate("xpack.apm.onboarding.config_otel.column.configValue",{defaultMessage:"Configuration value"}),render:(e,{value:a,setting:t,apiKey:i})=>(0,d.jsx)(pe,{setting:t,value:a,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading,apiKey:null==n?void 0:n.apiKey})},{field:"notes",name:u.i18n.translate("xpack.apm.onboarding.config_otel.column.notes",{defaultMessage:"Notes"})}];return(0,d.jsx)(i().Fragment,null,(0,d.jsx)(o.EuiBasicTable,{items:r,columns:s,"data-test-subj":"otel-instructions-table"}),(0,d.jsx)(o.EuiSpacer,{size:"m"}),(0,d.jsx)(o.EuiText,{size:"xs",color:"subdued"},(0,d.jsx)(c.FormattedMessage,{id:"xpack.apm.onboarding.config_otel.description1",defaultMessage:"(1) OpenTelemetry agents and SDKs must support the {otelExporterOtlpEndpoint}, {otelExporterOtlpHeaders}, and {otelResourceAttributes} variables; some unstable components may not yet comply with this requirement.",values:{otelExporterOtlpEndpoint:(0,d.jsx)(o.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOtelExporterOtlpEndpointLink",target:"_blank",href:"https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/protocol/exporter.md"},"OTEL_EXPORTER_OTLP_ENDPOINT"),otelExporterOtlpHeaders:(0,d.jsx)(o.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOtelExporterOtlpHeadersLink",target:"_blank",href:"https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/protocol/exporter.md"},"OTEL_EXPORTER_OTLP_HEADERS"),otelResourceAttributes:(0,d.jsx)(o.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOtelResourceAttributesLink",target:"_blank",href:"https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/resource/sdk.md"},"OTEL_RESOURCE_ATTRIBUTES")}}),(0,d.jsx)(o.EuiSpacer,{size:"xs"}),(0,d.jsx)(c.FormattedMessage,{id:"xpack.apm.onboarding.config_otel.description2",defaultMessage:"The 'OTEL_METRICS_EXPORTER` and 'OTEL_LOGS_EXPORTER' environment variables may not be supported by some SDKs."}),(0,d.jsx)(o.EuiSpacer,{size:"xs"}),(0,d.jsx)(c.FormattedMessage,{id:"xpack.apm.onboarding.config_otel.description3",defaultMessage:"The exhaustive list of environment variables, command line parameters, and configuration code snippets (according to the OpenTelemetry specification) is available in the {otelInstrumentationGuide}. Some unstable OpenTelemetry clients may not support all features and may require alternate configuration mechanisms.",values:{otelInstrumentationGuide:(0,d.jsx)(o.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOpenTelemetryInstrumentationGuideLink",target:"_blank",href:"https://opentelemetry.io/docs/instrumentation"},u.i18n.translate("xpack.apm.onboarding.config_otel.instrumentationGuide",{defaultMessage:"OpenTelemetry Instrumentation guide"}))}})))}function ge({baseUrl:e,config:a,checkAgentStatus:n,agentStatus:t,agentStatusLoading:i},r,o,s){const{apiKey:l,error:c,errorMessage:p}=o,d=Boolean(l)&&!c,g=c&&Boolean(p),m={baseUrl:e,apmServerUrl:`${a.managedServiceUrl}:443`,checkAgentStatus:n,agentStatus:t,agentStatusLoading:i,apiKeyDetails:{...o,displayApiKeySuccessCallout:d,displayApiKeyErrorCallout:g,createAgentKey:s,createApiKeyLoading:r}};return{title:u.i18n.translate("xpack.apm.tutorial.apmAgents.title",{defaultMessage:"APM Agents"}),instructionVariants:[{id:y.X.NODE,instructions:ne(m)},{id:y.X.DJANGO,instructions:te(m)},{id:y.X.FLASK,instructions:ie(m)},{id:y.X.RAILS,instructions:re(m)},{id:y.X.RACK,instructions:oe(m)},{id:y.X.GO,instructions:se(m)},{id:y.X.JAVA,instructions:ae(m)},{id:y.X.DOTNET,instructions:le(m)},{id:y.X.PHP,instructions:ue(m)},{id:y.X.OPEN_TELEMETRY,instructions:ce(m)}]}}function me(){const e=(0,p.D)("/app/apm");return(0,d.jsx)(o.EuiPanel,{paddingSize:"l"},(0,d.jsx)(o.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiText,null,(0,d.jsx)("p",null,(0,d.jsx)(c.FormattedMessage,{id:"xpack.apm.onboarding.footer.exploreYourDataDescription",defaultMessage:"When all steps are complete, you're ready to explore your data."})))),(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiButton,{"data-test-subj":"apmTutorialFooterButton",fill:!0,href:e},u.i18n.translate("xpack.apm.onboarding.footer.cta",{defaultMessage:"Launch APM"})))))}var ye=n(32336);function ke(){const[e,a]=(0,t.useState)([]),[n,i]=(0,t.useState)({apiKey:null,error:!1}),[u,c]=(0,t.useState)(!1),[p,m]=(0,t.useState)(),[y,k]=(0,t.useState)(!1),{services:f}=(0,r.useKibana)(),{config:x}=(0,l.W)(),{docLinks:v,observabilityShared:E}=f,A=(null==v?void 0:v.links.kibana.guide)||"https://www.elastic.co/guide/en/kibana/current/index.html",S=(null==v?void 0:v.ELASTIC_WEBSITE_URL)||"https://www.elastic.co/",b=async()=>{try{c(!0);const e=[ye.i_.EVENT],{agentKey:a}=await(0,s.L)("POST /api/apm/agent_keys 2023-10-31",{signal:null,params:{body:{name:`onboarding-${(Math.random()+1).toString(36).substring(7)}`,privileges:e}}});i({apiKey:a.encoded,id:a.id,error:!1})}catch(a){var e;i({apiKey:null,error:!0,errorMessage:(null===(e=a.body)||void 0===e?void 0:e.message)||a.message})}finally{c(!1)}},M=async()=>{try{k(!0);const e=await(0,s.L)("GET /internal/apm/observability_overview/has_data",{signal:null});m(e.hasData)}catch(e){m(!1)}finally{k(!1)}},j=e.length>0;(0,t.useEffect)((()=>{a([ge({baseUrl:S,config:x,checkAgentStatus:M,agentStatus:p,agentStatusLoading:y},u,n,b)])}),[n,S,x,u,p,y]);const T=E.navigation.PageTemplate;return(0,d.jsx)(T,null,(0,d.jsx)(g,{isBeta:!1,guideLink:A}),(0,d.jsx)(o.EuiSpacer,null),j&&e.map((e=>(0,d.jsx)("div",{key:e.title},(0,d.jsx)(h,{instructions:e}),(0,d.jsx)(o.EuiSpacer,null)))),(0,d.jsx)(me,null))}}}]);