"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRootTransactionByTraceId = getRootTransactionByTraceId;
var _common = require("@kbn/observability-plugin/common");
var _server = require("@kbn/observability-plugin/server");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _maybe2 = require("../../../../common/utils/maybe");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _apm = require("../../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getRootTransactionByTraceId({
  traceId,
  apmEventClient,
  start,
  end
}) {
  var _maybe;
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apm.TRACE_ID, _apm.TRANSACTION_ID, _apm.TRANSACTION_NAME, _apm.AT_TIMESTAMP, _apm.TRANSACTION_TYPE, _apm.TRANSACTION_DURATION, _apm.SERVICE_NAME]);
  const params = {
    apm: {
      events: [_common.ProcessorEvent.transaction]
    },
    body: {
      track_total_hits: false,
      size: 1,
      terminate_after: 1,
      query: {
        bool: {
          should: [{
            constant_score: {
              filter: {
                bool: {
                  must_not: {
                    exists: {
                      field: _apm.PARENT_ID
                    }
                  }
                }
              }
            }
          }],
          filter: [{
            term: {
              [_apm.TRACE_ID]: traceId
            }
          }, ...(0, _server.rangeQuery)(start, end)]
        }
      },
      fields: requiredFields
    }
  };
  const resp = await apmEventClient.search('get_root_transaction_by_trace_id', params);
  const event = (0, _utils.unflattenKnownApmEventFields)((_maybe = (0, _maybe2.maybe)(resp.hits.hits[0])) === null || _maybe === void 0 ? void 0 : _maybe.fields, requiredFields);
  return {
    transaction: event
  };
}