"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apmIndicesRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _apm_indices = require("@kbn/apm-data-access-plugin/server/saved_objects/apm_indices");
var _create_apm_server_route = require("../../apm_routes/create_apm_server_route");
var _get_apm_indices = require("./get_apm_indices");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// get list of apm indices and values
const apmIndexSettingsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/settings/apm-index-settings',
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmIndexSettings = await (0, _get_apm_indices.getApmIndexSettings)(resources);
    return {
      apmIndexSettings
    };
  }
});

// get apm indices configuration object
const apmIndicesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/settings/apm-indices',
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    return await resources.getApmIndices();
  }
});
// save ui indices
const saveApmIndicesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/settings/apm-indices/save',
  security: {
    authz: {
      requiredPrivileges: ['apm', 'apm_settings_write']
    }
  },
  params: t.type({
    body: t.partial({
      error: t.string,
      onboarding: t.string,
      span: t.string,
      transaction: t.string,
      metric: t.string,
      // Keeping this one here for backward compatibility
      sourcemap: t.string
    })
  }),
  handler: async resources => {
    const {
      params,
      context
    } = resources;
    const {
      body
    } = params;
    const savedObjectsClient = (await context.core).savedObjects.client;
    const indices = {
      ...body
    };
    if (indices.sourcemap) {
      // Delete this as we stopped supporting it from 8.7.
      delete indices.sourcemap;
    }
    return await (0, _apm_indices.saveApmIndices)(savedObjectsClient, indices);
  }
});
const apmIndicesRouteRepository = exports.apmIndicesRouteRepository = {
  ...apmIndexSettingsRoute,
  ...apmIndicesRoute,
  ...saveApmIndicesRoute
};