"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentConfigEtagMetrics = getAgentConfigEtagMetrics;
var _server = require("@kbn/observability-plugin/server");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAgentConfigEtagMetrics(apmEventClient, etag) {
  var _response$aggregation, _response$aggregation2;
  const params = {
    apm: {
      events: [_common.ProcessorEvent.metric]
    },
    body: {
      track_total_hits: 0,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.termQuery)(_apm.METRICSET_NAME, 'agent_config'), ...(0, _server.termQuery)('labels.etag', etag), ...(0, _server.rangeQuery)(_datemath.default.parse('now-15m').valueOf(), _datemath.default.parse('now').valueOf())]
        }
      },
      aggs: {
        config_by_etag: {
          terms: {
            field: 'labels.etag',
            size: 200
          }
        }
      }
    }
  };
  const response = await apmEventClient.search('get_agent_config_etag_metrics', params);
  return (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.config_by_etag.buckets.map(({
    key
  }) => key)) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
}