"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSeries = fetchSeries;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchSeries({
  apmEventClient,
  operationName,
  documentType,
  rollupInterval,
  intervalString,
  start,
  end,
  filter,
  groupByFields,
  aggs,
  unit
}) {
  var _response$aggregation;
  const response = await apmEventClient.search(operationName, {
    apm: {
      sources: [{
        documentType,
        rollupInterval
      }]
    },
    body: {
      size: 0,
      track_total_hits: false,
      query: {
        bool: {
          filter
        }
      },
      aggs: {
        groups: {
          ...(groupByFields.length === 1 ? {
            terms: {
              size: 20,
              field: groupByFields[0]
            }
          } : {
            multi_terms: {
              size: 20,
              terms: groupByFields.map(field => ({
                field
              }))
            }
          }),
          aggs: {
            ...aggs,
            timeseries: {
              date_histogram: {
                field: '@timestamp',
                fixed_interval: intervalString,
                min_doc_count: 0,
                extended_bounds: {
                  min: start,
                  max: end
                }
              },
              aggs
            },
            change_point: {
              change_point: {
                buckets_path: 'timeseries>value'
              }
            }
          }
        }
      }
    }
  });
  if (!((_response$aggregation = response.aggregations) !== null && _response$aggregation !== void 0 && _response$aggregation.groups)) {
    return [];
  }
  return response.aggregations.groups.buckets.map(bucket => {
    const bucketValue = bucket.value;
    let value = (bucketValue === null || bucketValue === void 0 ? void 0 : bucketValue.value) === undefined || (bucketValue === null || bucketValue === void 0 ? void 0 : bucketValue.value) === null ? null : Number(bucketValue.value);
    if (value !== null) {
      value = Math.abs(value) < 100 ? Number(value.toPrecision(3)) : Math.round(value);
    }
    return {
      groupBy: bucket.key_as_string || String(bucket.key),
      data: bucket.timeseries.buckets,
      value,
      change_point: bucket.change_point,
      unit
    };
  });
}