"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmTimeRangeMetadataContextProvider = ApmTimeRangeMetadataContextProvider;
exports.TimeRangeMetadataContext = void 0;
exports.TimeRangeMetadataContextProvider = TimeRangeMetadataContextProvider;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _use_apm_params = require("../../hooks/use_apm_params");
var _use_apm_route_path = require("../../hooks/use_apm_route_path");
var _use_fetcher = require("../../hooks/use_fetcher");
var _use_time_range = require("../../hooks/use_time_range");
var _use_apm_plugin_context = require("../apm_plugin/use_apm_plugin_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimeRangeMetadataContext = exports.TimeRangeMetadataContext = /*#__PURE__*/(0, _react.createContext)(undefined);
function ApmTimeRangeMetadataContextProvider({
  children
}) {
  const {
    core: {
      uiSettings
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/*');
  const kuery = 'kuery' in query && query.kuery ? query.kuery : '';
  const range = 'rangeFrom' in query && 'rangeTo' in query ? {
    rangeFrom: query.rangeFrom,
    rangeTo: query.rangeTo
  } : undefined;
  if (!range) {
    throw new Error('rangeFrom/rangeTo missing in URL');
  }
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)(range);
  const routePath = (0, _use_apm_route_path.useApmRoutePath)();
  const isOperationView = routePath.startsWith('/dependencies/operation') || routePath.startsWith('/dependencies/operations');
  return /*#__PURE__*/_react.default.createElement(TimeRangeMetadataContextProvider, {
    uiSettings: uiSettings,
    useSpanName: isOperationView,
    start: start,
    end: end,
    kuery: kuery
  }, children);
}
function TimeRangeMetadataContextProvider({
  children,
  uiSettings,
  useSpanName,
  start,
  end,
  kuery
}) {
  const enableServiceTransactionMetrics = uiSettings.get(_common.apmEnableServiceMetrics, true);
  const enableContinuousRollups = uiSettings.get(_common.apmEnableContinuousRollups, true);
  const fetcherResult = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/time_range_metadata', {
      params: {
        query: {
          start,
          end,
          kuery,
          useSpanName,
          enableServiceTransactionMetrics,
          enableContinuousRollups
        }
      }
    });
  }, [start, end, kuery, useSpanName, enableServiceTransactionMetrics, enableContinuousRollups]);
  return /*#__PURE__*/_react.default.createElement(TimeRangeMetadataContext.Provider, {
    value: fetcherResult
  }, children);
}