"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TryItButton = TryItButton;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_local_storage = require("../../../hooks/use_local_storage");
var _technical_preview_badge = require("../technical_preview_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TryItButton({
  isFeatureEnabled,
  linkLabel,
  onClick,
  popoverContent,
  promoLabel,
  isLoading
}) {
  var _core$application$cap;
  const [showFastFilterTryCallout, setShowFastFilterTryCallout] = (0, _use_local_storage.useLocalStorage)('apm.showFastFilterTryCallout', true);
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const canEditAdvancedSettings = (_core$application$cap = core.application.capabilities.advancedSettings) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.save;
  const [isPopoverOpen, togglePopover] = (0, _useToggle.default)(false);
  if (!showFastFilterTryCallout) {
    return null;
  }
  function PromoLabel() {
    if (!promoLabel) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, promoLabel));
  }
  function Popover() {
    if (!popoverContent) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "apmPopoverButton",
        iconType: "iInCircle",
        "aria-label": _i18n.i18n.translate('xpack.apm.tryItButton.euiButtonIcon.tryItHelperButtonLabel', {
          defaultMessage: 'Try it helper button'
        }),
        onClick: togglePopover
      }),
      isOpen: isPopoverOpen,
      closePopover: togglePopover,
      anchorPosition: "upCenter"
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, popoverContent)));
  }
  function Link() {
    if (!linkLabel) {
      return null;
    }
    const linkComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "apmLink",
      disabled: isLoading || !canEditAdvancedSettings,
      onClick: onClick
    }, linkLabel));
    if (!canEditAdvancedSettings) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          direction: "column"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          direction: "row"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "lock",
          size: "s"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs"
        }, _i18n.i18n.translate('xpack.apm.tryItButton.euiButtonIcon.featureDisabled', {
          defaultMessage: 'This feature is currently disabled.'
        }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs"
        }, _i18n.i18n.translate('xpack.apm.tryItButton.euiButtonIcon.admin', {
          defaultMessage: 'Please speak to you administrator to turn {featureEnabled} this feature.',
          values: {
            featureEnabled: isFeatureEnabled ? _i18n.i18n.translate('xpack.apm.tryItButton.euiButtonIcon.admin.off', {
              defaultMessage: 'off'
            }) : _i18n.i18n.translate('xpack.apm.tryItButton.euiButtonIcon.admin.on', {
              defaultMessage: 'on'
            })
          }
        }))))
      }, linkComponent);
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, linkComponent);
  }
  function Loading() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    })));
  }
  function HideThisButton() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: "Hide this"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "apmHideThisButtonButton",
      iconType: "cross",
      onClick: () => {
        setShowFastFilterTryCallout(false);
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    icon: "beaker"
  }), isFeatureEnabled ? null : /*#__PURE__*/_react.default.createElement(PromoLabel, null), /*#__PURE__*/_react.default.createElement(Link, null), /*#__PURE__*/_react.default.createElement(Popover, null), /*#__PURE__*/_react.default.createElement(Loading, null), /*#__PURE__*/_react.default.createElement(HideThisButton, null));
}