"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomLinkFlyout = CustomLinkFlyout;
var _react = _interopRequireWildcard(require("react"));
var _use_fetcher = require("../../../hooks/use_fetcher");
var _helper = require("../../app/settings/custom_link/create_edit_custom_link_flyout/helper");
var _create_edit_custom_link_flyout = require("../../app/settings/custom_link/create_edit_custom_link_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CustomLinkFlyout({
  transaction,
  isOpen,
  onClose
}) {
  const filters = (0, _react.useMemo)(() => [{
    key: 'service.name',
    value: transaction === null || transaction === void 0 ? void 0 : transaction.service.name
  }, {
    key: 'service.environment',
    value: transaction === null || transaction === void 0 ? void 0 : transaction.service.environment
  }, {
    key: 'transaction.name',
    value: transaction === null || transaction === void 0 ? void 0 : transaction.transaction.name
  }, {
    key: 'transaction.type',
    value: transaction === null || transaction === void 0 ? void 0 : transaction.transaction.type
  }].filter(filter => typeof filter.value === 'string'), [transaction]);
  const {
    refetch
  } = (0, _use_fetcher.useFetcher)(callApmApi => callApmApi('GET /internal/apm/settings/custom_links', {
    isCachable: false,
    params: {
      query: (0, _helper.convertFiltersToQuery)(filters)
    }
  }), [filters]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isOpen && /*#__PURE__*/_react.default.createElement(_create_edit_custom_link_flyout.CreateEditCustomLinkFlyout, {
    defaults: {
      filters
    },
    onClose: () => {
      onClose();
    },
    onSave: () => {
      onClose();
      refetch();
    },
    onDelete: () => {
      onClose();
      refetch();
    }
  }));
}