"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogErrorRateChart = LogErrorRateChart;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _common = require("@kbn/observability-shared-plugin/common");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _formatters = require("../../../../../common/utils/formatters");
var _tooltip_content = require("./tooltip_content");
var _popover = require("./popover");
var _kuery_utils = require("../../../../../common/utils/kuery_utils");
var _apm = require("../../../../../common/es_fields/apm");
var _explore_logs_button = require("../../explore_logs_button/explore_logs_button");
var _timeseries_chart_with_context = require("../timeseries_chart_with_context");
var _get_metrics_formulas = require("../helper/get_metrics_formulas");
var _get_timeseries_color = require("../helper/get_timeseries_color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_STATE = {
  currentPeriod: {}
};
function LogErrorRateChart({
  height
}) {
  var _data$currentPeriod$s, _data$currentPeriod;
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery
    },
    path: {
      serviceName
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data = INITIAL_STATE,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end) {
      return callApmApi('GET /internal/apm/entities/services/{serviceName}/logs_error_rate_timeseries', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end]);
  const {
    currentPeriodColor
  } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LOG_ERROR_RATE);
  const timeseries = [{
    data: (_data$currentPeriod$s = data === null || data === void 0 ? void 0 : (_data$currentPeriod = data.currentPeriod) === null || _data$currentPeriod === void 0 ? void 0 : _data$currentPeriod[serviceName]) !== null && _data$currentPeriod$s !== void 0 ? _data$currentPeriod$s : [],
    type: 'linemark',
    color: currentPeriodColor,
    title: _i18n.i18n.translate('xpack.apm.logs.chart.logsErrorRate', {
      defaultMessage: 'Log Error Rate'
    })
  }];
  const errorLogKueryFormat = (0, _kuery_utils.mergeKueries)([(0, _kuery_utils.toKueryFilterFormat)(_apm.LOG_LEVEL, ['error', 'ERROR']), (0, _kuery_utils.toKueryFilterFormat)(_apm.ERROR_LOG_LEVEL, ['error', 'ERROR'])], 'OR');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.logErrorRate', {
    defaultMessage: 'Log error rate'
  }), ' ', /*#__PURE__*/_react.default.createElement(_popover.Popover, null, /*#__PURE__*/_react.default.createElement(_tooltip_content.TooltipContent, {
    formula: (0, _get_metrics_formulas.getMetricsFormula)(_get_metrics_formulas.ChartMetricType.LOG_ERROR_RATE),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Rate of error logs per minute observed for given {serviceName}.",
      id: "xpack.apm.logErrorRate.tooltip.description",
      values: {
        serviceName: /*#__PURE__*/_react.default.createElement("code", {
          css: (0, _react2.css)`
                                word-break: break-word;
                              `
        }, _i18n.i18n.translate('xpack.apm.multiSignal.servicesTable.logErrorRate.tooltip.serviceNameLabel', {
          defaultMessage: 'service.name'
        }))
      }
    })
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_explore_logs_button.ExploreLogsButton, {
    start: start,
    end: end,
    kuery: (0, _kuery_utils.mergeKueries)([`(${errorLogKueryFormat})`, (0, _kuery_utils.toKueryFilterFormat)(_common.SERVICE_NAME, [serviceName])])
  })))), /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_context.TimeseriesChartWithContext, {
    id: "logErrorRate",
    height: height,
    showAnnotations: false,
    fetchStatus: status,
    timeseries: timeseries,
    yLabelFormat: _formatters.asDecimalOrInteger
  }));
}