"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceTabEmptyState = ServiceTabEmptyState;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_kibana_url = require("../../../hooks/use_kibana_url");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const baseImgFolder = '/plugins/apm/assets/service_tab_empty_state';
const defaultAddDataTelemetryParams = {
  view: 'add_apm_cta'
};
const defaultClickTelemetryParams = {
  view: 'add_apm_cta'
};
function ServiceTabEmptyState({
  id,
  onDismiss
}) {
  const {
    services: {
      telemetry
    }
  } = (0, _public.useKibana)();
  const {
    share
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const onboardingLocator = share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  const imgBaseFolderPath = (0, _use_kibana_url.useKibanaUrl)(baseImgFolder);
  function handleAddAPMClick() {
    telemetry.reportEntityInventoryAddData(defaultAddDataTelemetryParams);
  }
  function handleTryItClick() {
    telemetry.reportTryItClick(defaultClickTelemetryParams);
  }
  function handleLearnMoreClick() {
    telemetry.reportLearnMoreClick(defaultClickTelemetryParams);
  }
  return /*#__PURE__*/_react.default.createElement(_public2.AddDataPanel, {
    "data-test-subj": "apmAddApmCallout",
    content: (0, _constants.addAPMCalloutDefinitions)(imgBaseFolderPath, onboardingLocator)[id].content,
    actions: (0, _constants.addAPMCalloutDefinitions)(imgBaseFolderPath, onboardingLocator)[id].actions,
    onAddData: handleAddAPMClick,
    onTryIt: handleTryItClick,
    onLearnMore: handleLearnMoreClick,
    onDismiss: onDismiss
  });
}