"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceOverviewErrorsTable = ServiceOverviewErrorsTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _overview_table_container = require("../../../shared/overview_table_container");
var _error_overview_link = require("../../../shared/links/apm/error_overview_link");
var _error_group_list = require("../../error_group_overview/error_group_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServiceOverviewErrorsTable({
  serviceName
}) {
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/overview');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "serviceOverviewErrorsTable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serviceOverview.errorsTableTitle', {
    defaultMessage: 'Errors'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_error_overview_link.ErrorOverviewLink, {
    serviceName: serviceName,
    query: query
  }, _i18n.i18n.translate('xpack.apm.serviceOverview.errorsTableLinkText', {
    defaultMessage: 'View errors'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview_table_container.OverviewTableContainer, {
    fixedHeight: true,
    isEmptyAndNotInitiated: false
  }, /*#__PURE__*/_react.default.createElement(_error_group_list.ErrorGroupList, {
    serviceName: serviceName,
    initialPageSize: 5,
    isCompactMode: true,
    saveTableOptionsToUrl: false,
    showPerPageOptions: false
  }))));
}