"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetection = AnomalyDetection;
exports.ContentLine = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _anomaly_detection = require("../../../../../common/anomaly_detection");
var _service_health_status = require("../../../../../common/service_health_status");
var _transaction_types = require("../../../../../common/transaction_types");
var _formatters = require("../../../../../common/utils/formatters");
var _mlsingle_metric_link = require("../../../shared/links/machine_learning_links/mlsingle_metric_link");
var _cytoscape_options = require("../cytoscape_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HealthStatusTitle = (0, _styled.default)(_eui.EuiTitle)`
  display: inline;
  text-transform: uppercase;
`;
const VerticallyCentered = _styled.default.div`
  display: flex;
  align-items: center;
`;
const SubduedText = _styled.default.span`
  color: ${({
  theme
}) => theme.euiTheme.colors.textSubdued};
`;
const EnableText = _styled.default.section`
  color: ${({
  theme
}) => theme.euiTheme.colors.textSubdued};
  line-height: 1.4;
  font-size: ${() => (0, _eui.useEuiFontSize)('s').fontSize};
  width: ${_cytoscape_options.popoverWidth}px;
`;
const ContentLine = exports.ContentLine = _styled.default.section`
  line-height: 2;
`;
function AnomalyDetection({
  serviceName,
  serviceAnomalyStats
}) {
  var _serviceAnomalyStats$;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const anomalyScore = serviceAnomalyStats === null || serviceAnomalyStats === void 0 ? void 0 : serviceAnomalyStats.anomalyScore;
  const severity = (0, _anomaly_detection.getSeverity)(anomalyScore);
  const actualValue = serviceAnomalyStats === null || serviceAnomalyStats === void 0 ? void 0 : serviceAnomalyStats.actualValue;
  const mlJobId = serviceAnomalyStats === null || serviceAnomalyStats === void 0 ? void 0 : serviceAnomalyStats.jobId;
  const transactionType = (_serviceAnomalyStats$ = serviceAnomalyStats === null || serviceAnomalyStats === void 0 ? void 0 : serviceAnomalyStats.transactionType) !== null && _serviceAnomalyStats$ !== void 0 ? _serviceAnomalyStats$ : _transaction_types.TRANSACTION_REQUEST;
  const hasAnomalyDetectionScore = anomalyScore !== undefined;
  const healthStatus = (0, _service_health_status.getServiceHealthStatus)({
    severity
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("section", null, /*#__PURE__*/_react.default.createElement(HealthStatusTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, ANOMALY_DETECTION_TITLE)), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "iInCircle",
    content: ANOMALY_DETECTION_TOOLTIP
  }), !mlJobId && /*#__PURE__*/_react.default.createElement(EnableText, null, ANOMALY_DETECTION_DISABLED_TEXT)), hasAnomalyDetectionScore && /*#__PURE__*/_react.default.createElement(ContentLine, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(VerticallyCentered, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: (0, _service_health_status.getServiceHealthStatusColor)(euiTheme, healthStatus)
  }), /*#__PURE__*/_react.default.createElement(SubduedText, null, ANOMALY_DETECTION_SCORE_METRIC))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, getDisplayedAnomalyScore(anomalyScore), actualValue && /*#__PURE__*/_react.default.createElement(SubduedText, null, "\xA0(", (0, _formatters.asDuration)(actualValue), ")"))))), mlJobId && !hasAnomalyDetectionScore && /*#__PURE__*/_react.default.createElement(EnableText, null, ANOMALY_DETECTION_NO_DATA_TEXT), mlJobId && /*#__PURE__*/_react.default.createElement(ContentLine, null, /*#__PURE__*/_react.default.createElement(_mlsingle_metric_link.MLSingleMetricLink, {
    external: true,
    jobId: mlJobId,
    serviceName: serviceName,
    transactionType: transactionType
  }, ANOMALY_DETECTION_LINK)));
}
function getDisplayedAnomalyScore(score) {
  if (score > 0 && score < 1) {
    return '< 1';
  }
  return (0, _formatters.asInteger)(score);
}
const ANOMALY_DETECTION_TITLE = _i18n.i18n.translate('xpack.apm.serviceMap.anomalyDetectionPopoverTitle', {
  defaultMessage: 'Anomaly Detection'
});
const ANOMALY_DETECTION_TOOLTIP = _i18n.i18n.translate('xpack.apm.serviceMap.anomalyDetectionPopoverTooltip', {
  defaultMessage: 'Service health indicators are powered by the anomaly detection feature in machine learning'
});
const ANOMALY_DETECTION_SCORE_METRIC = _i18n.i18n.translate('xpack.apm.serviceMap.anomalyDetectionPopoverScoreMetric', {
  defaultMessage: 'Score (max.)'
});
const ANOMALY_DETECTION_LINK = _i18n.i18n.translate('xpack.apm.serviceMap.anomalyDetectionPopoverLink', {
  defaultMessage: 'View anomalies'
});
const ANOMALY_DETECTION_DISABLED_TEXT = _i18n.i18n.translate('xpack.apm.serviceMap.anomalyDetectionPopoverDisabled', {
  defaultMessage: 'Display service health indicators by enabling anomaly detection in APM settings.'
});
const ANOMALY_DETECTION_NO_DATA_TEXT = _i18n.i18n.translate('xpack.apm.serviceMap.anomalyDetectionPopoverNoData', {
  defaultMessage: `We couldn't find an anomaly score within the selected time range. See details in the anomaly explorer.`
});