"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveDashboardModal = SaveDashboardModal;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _use_dashboards_fetcher = require("../../../../hooks/use_dashboards_fetcher");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _apm = require("../../../../../common/es_fields/apm");
var _url_helpers = require("../../../shared/links/url_helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SaveDashboardModal({
  onClose,
  onRefresh,
  currentDashboard,
  serviceDashboards,
  serviceName
}) {
  var _ref;
  const {
    core: {
      notifications
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    data: allAvailableDashboards,
    status
  } = (0, _use_dashboards_fetcher.useDashboardFetcher)();
  const history = (0, _reactRouterDom.useHistory)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [serviceFiltersEnabled, setServiceFiltersEnabled] = (0, _react.useState)((_ref = (currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.serviceEnvironmentFilterEnabled) && (currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.serviceNameFilterEnabled)) !== null && _ref !== void 0 ? _ref : true);
  const [selectedDashboard, setSelectedDashboard] = (0, _react.useState)(currentDashboard ? [{
    label: currentDashboard.title,
    value: currentDashboard.dashboardSavedObjectId
  }] : []);
  const isEditMode = !!(currentDashboard !== null && currentDashboard !== void 0 && currentDashboard.id);
  const options = allAvailableDashboards === null || allAvailableDashboards === void 0 ? void 0 : allAvailableDashboards.map(dashboardItem => {
    var _serviceDashboards$so;
    return {
      label: dashboardItem.attributes.title,
      value: dashboardItem.id,
      disabled: (_serviceDashboards$so = serviceDashboards === null || serviceDashboards === void 0 ? void 0 : serviceDashboards.some(({
        dashboardSavedObjectId
      }) => dashboardItem.id === dashboardSavedObjectId)) !== null && _serviceDashboards$so !== void 0 ? _serviceDashboards$so : false
    };
  });
  const onClickSave = (0, _react.useCallback)(async function () {
    const [newDashboard] = selectedDashboard;
    try {
      if (newDashboard.value) {
        setIsLoading(true);
        await (0, _create_call_apm_api.callApmApi)('POST /internal/apm/custom-dashboard', {
          params: {
            query: {
              customDashboardId: currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.id
            },
            body: {
              dashboardSavedObjectId: newDashboard.value,
              serviceEnvironmentFilterEnabled: serviceFiltersEnabled,
              serviceNameFilterEnabled: serviceFiltersEnabled,
              kuery: `${_apm.SERVICE_NAME}: ${serviceName}`
            }
          },
          signal: null
        });
        notifications.toasts.addSuccess(isEditMode ? getEditSuccessToastLabels(newDashboard.label) : getLinkSuccessToastLabels(newDashboard.label));
        history.push({
          ...history.location,
          search: (0, _url_helpers.fromQuery)({
            ...(0, _url_helpers.toQuery)(location.search),
            dashboardId: newDashboard.value
          })
        });
        onRefresh();
      }
    } catch (error) {
      console.error(error);
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.serviceDashboards.addFailure.toast.title', {
          defaultMessage: 'Error while adding "{dashboardName}" dashboard',
          values: {
            dashboardName: newDashboard.label
          }
        }),
        text: error.body.message
      });
    }
    setIsLoading(false);
    onClose();
  }, [selectedDashboard, notifications.toasts, serviceFiltersEnabled, onClose, onRefresh, isEditMode, serviceName, currentDashboard, history]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "data-test-subj": "apmSelectServiceDashboard"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, isEditMode ? _i18n.i18n.translate('xpack.apm.serviceDashboards.selectDashboard.modalTitle.edit', {
    defaultMessage: 'Edit dashboard'
  }) : _i18n.i18n.translate('xpack.apm.serviceDashboards.selectDashboard.modalTitle.link', {
    defaultMessage: 'Select dashboard'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING || isLoading,
    isDisabled: status === _use_fetcher.FETCH_STATUS.LOADING || isEditMode,
    placeholder: _i18n.i18n.translate('xpack.apm.serviceDashboards.selectDashboard.placeholder', {
      defaultMessage: 'Select dashboard'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selectedDashboard,
    onChange: newSelection => setSelectedDashboard(newSelection),
    isClearable: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    css: {
      alignItems: 'center'
    },
    compressed: true,
    label: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.dashboard.addDashboard.useContextFilterLabel', {
      defaultMessage: 'Filter by service and environment'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: _i18n.i18n.translate('xpack.apm.dashboard.addDashboard.useContextFilterLabel.tooltip', {
        defaultMessage: 'Enabling this option will apply filters to the dashboard based on your chosen service and environment.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "questionInCircle",
      title: _i18n.i18n.translate('xpack.apm.saveDashboardModal.euiIcon.iconWithTooltipLabel', {
        defaultMessage: 'Icon with tooltip'
      })
    }))),
    onChange: () => setServiceFiltersEnabled(!serviceFiltersEnabled),
    checked: serviceFiltersEnabled
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmSelectDashboardCancelButton",
    onClick: onClose,
    isDisabled: status === _use_fetcher.FETCH_STATUS.LOADING || isLoading
  }, _i18n.i18n.translate('xpack.apm.serviceDashboards.selectDashboard.cancel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmSelectDashboardButton",
    onClick: onClickSave,
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING || isLoading,
    fill: true
  }, isEditMode ? _i18n.i18n.translate('xpack.apm.serviceDashboards.selectDashboard.edit', {
    defaultMessage: 'Save'
  }) : _i18n.i18n.translate('xpack.apm.serviceDashboards.selectDashboard.add', {
    defaultMessage: 'Link dashboard'
  }))));
}
function getLinkSuccessToastLabels(dashboardName) {
  return {
    title: _i18n.i18n.translate('xpack.apm.serviceDashboards.linkSuccess.toast.title', {
      defaultMessage: 'Added "{dashboardName}" dashboard',
      values: {
        dashboardName
      }
    }),
    text: _i18n.i18n.translate('xpack.apm.serviceDashboards.linkSuccess.toast.text', {
      defaultMessage: 'Your dashboard is now visible in the service overview page.'
    })
  };
}
function getEditSuccessToastLabels(dashboardName) {
  return {
    title: _i18n.i18n.translate('xpack.apm.serviceDashboards.editSuccess.toast.title', {
      defaultMessage: 'Edited "{dashboardName}" dashboard',
      values: {
        dashboardName
      }
    }),
    text: _i18n.i18n.translate('xpack.apm.serviceDashboards.editSuccess.toast.text', {
      defaultMessage: 'Your dashboard link has been updated'
    })
  };
}