"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmDataAccessPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _migrate_legacy_apm_indices_to_space_aware = require("./saved_objects/migrations/migrate_legacy_apm_indices_to_space_aware");
var _apm_indices = require("./saved_objects/apm_indices");
var _get_services = require("./services/get_services");
var _check_privileges = require("./lib/check_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ApmDataAccessPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "server", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "getApmIndices", async savedObjectsClient => {
      const apmIndicesFromSavedObject = await (0, _apm_indices.getApmIndicesSavedObject)(savedObjectsClient);
      return {
        ...this.config.indices,
        ...apmIndicesFromSavedObject
      };
    });
    this.config = initContext.config.get();
    this.logger = initContext.logger.get();
  }
  setup(core) {
    // register saved object
    core.savedObjects.registerType(_apm_indices.apmIndicesSavedObjectDefinition);

    // expose
    return {
      apmIndicesFromConfigFile: this.config.indices,
      getApmIndices: this.getApmIndices,
      getServices: _get_services.getServices
    };
  }
  start(core, plugins) {
    // TODO: remove in 9.0
    (0, _migrate_legacy_apm_indices_to_space_aware.migrateLegacyAPMIndicesToSpaceAware)({
      coreStart: core,
      logger: this.logger
    }).catch(e => {
      this.logger.error('Failed to run migration making APM indices space aware');
      this.logger.error(e);
    });
    const getApmIndicesWithInternalUserFn = async () => {
      const soClient = core.savedObjects.createInternalRepository();
      return this.getApmIndices(soClient);
    };
    const startServices = {
      hasPrivileges: ({
        request
      }) => (0, _check_privileges.checkPrivileges)({
        request,
        getApmIndices: getApmIndicesWithInternalUserFn,
        security: plugins.security
      })
    };
    return {
      ...startServices
    };
  }
  stop() {}
}
exports.ApmDataAccessPlugin = ApmDataAccessPlugin;