"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkPrivileges = checkPrivileges;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function checkPrivileges({
  request,
  getApmIndices,
  security
}) {
  const authorization = security === null || security === void 0 ? void 0 : security.authz;
  if (!authorization) {
    return true;
  }
  const [apmIndices, checkPrivilegesFn] = await Promise.all([getApmIndices(), authorization.checkPrivilegesDynamicallyWithRequest(request)]);
  const {
    hasAllRequested
  } = await checkPrivilegesFn({
    elasticsearch: {
      cluster: [],
      index: (0, _lodash.mapValues)(apmIndices, () => ['read'])
    }
  });
  return hasAllRequested;
}