"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "APMEventClient", {
  enumerable: true,
  get: function () {
    return _helpers.APMEventClient;
  }
});
exports.config = void 0;
exports.plugin = plugin;
var _configSchema = require("@kbn/config-schema");
var _helpers = require("./lib/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const configSchema = _configSchema.schema.object({
  indices: _configSchema.schema.object({
    transaction: _configSchema.schema.string({
      defaultValue: 'traces-apm*,apm-*,traces-*.otel-*'
    }),
    // TODO: remove apm-* pattern in 9.0
    span: _configSchema.schema.string({
      defaultValue: 'traces-apm*,apm-*,traces-*.otel-*'
    }),
    error: _configSchema.schema.string({
      defaultValue: 'logs-apm*,apm-*,logs-*.otel-*'
    }),
    metric: _configSchema.schema.string({
      defaultValue: 'metrics-apm*,apm-*,metrics-*.otel-*'
    }),
    onboarding: _configSchema.schema.string({
      defaultValue: 'apm-*'
    }),
    // Unused: to be deleted
    sourcemap: _configSchema.schema.string({
      defaultValue: 'apm-*'
    }) // Unused: to be deleted
  })
});

// plugin config
const config = exports.config = {
  deprecations: ({
    renameFromRoot,
    unused,
    deprecate
  }) => [
  // deprecations
  deprecate('indices.sourcemap', 'a future version', {
    level: 'warning',
    message: `Configuring "xpack.apm.indices.sourcemap" is deprecated and will be removed in a future version. Please remove this setting.`
  }), deprecate('indices.onboarding', 'a future version', {
    level: 'warning',
    message: `Configuring "xpack.apm.indices.onboarding" is deprecated and will be removed in a future version. Please remove this setting.`
  }),
  // deprecations due to removal of apm_oss plugin
  renameFromRoot('apm_oss.transactionIndices', 'xpack.apm.indices.transaction', {
    level: 'warning'
  }), renameFromRoot('apm_oss.spanIndices', 'xpack.apm.indices.span', {
    level: 'warning'
  }), renameFromRoot('apm_oss.errorIndices', 'xpack.apm.indices.error', {
    level: 'warning'
  }), renameFromRoot('apm_oss.metricsIndices', 'xpack.apm.indices.metric', {
    level: 'warning'
  }), renameFromRoot('apm_oss.onboardingIndices', 'xpack.apm.indices.onboarding', {
    level: 'warning'
  }),
  // rename from apm to apm_data_access plugin
  renameFromRoot('xpack.apm.indices.transaction', 'xpack.apm_data_access.indices.transaction', {
    level: 'warning',
    silent: true
  }), renameFromRoot('xpack.apm.indices.span', 'xpack.apm_data_access.indices.span', {
    level: 'warning'
  }), renameFromRoot('xpack.apm.indices.error', 'xpack.apm_data_access.indices.error', {
    level: 'warning'
  }), renameFromRoot('xpack.apm.indices.metric', 'xpack.apm_data_access.indices.metric', {
    level: 'warning'
  }), renameFromRoot('xpack.apm.indices.sourcemap', 'xpack.apm_data_access.indices.sourcemap', {
    level: 'warning'
  }), renameFromRoot('xpack.apm.indices.onboarding', 'xpack.apm_data_access.indices.onboarding', {
    level: 'warning'
  })],
  schema: configSchema
};
async function plugin(initializerContext) {
  const {
    ApmDataAccessPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new ApmDataAccessPlugin(initializerContext);
}