"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schemaUnknownArray = exports.schemaUnknown = exports.schemaStringOrNumberArray = exports.schemaStringOrNumber = exports.schemaStringArray = exports.schemaString = exports.schemaNumberArray = exports.schemaNumber = exports.schemaGeoPointArray = exports.schemaGeoPoint = exports.schemaDateRangeArray = exports.schemaDateRange = exports.schemaDateArray = exports.schemaDate = exports.schemaBooleanArray = exports.schemaBoolean = exports.ObservabilityUptimeAlertSchema = exports.IsoDateString = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _alert_schema = require("./alert_schema");
var _legacy_alert_schema = require("./legacy_alert_schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// ---------------------------------- WARNING ----------------------------------
// this file was generated, and should not be edited by hand
// ---------------------------------- WARNING ----------------------------------

const ISO_DATE_PATTERN = /^d{4}-d{2}-d{2}Td{2}:d{2}:d{2}.d{3}Z$/;
const IsoDateString = exports.IsoDateString = new rt.Type('IsoDateString', rt.string.is, (input, context) => {
  if (typeof input === 'string' && ISO_DATE_PATTERN.test(input)) {
    return rt.success(input);
  } else {
    return rt.failure(input, context);
  }
}, rt.identity);
const schemaUnknown = exports.schemaUnknown = rt.unknown;
const schemaUnknownArray = exports.schemaUnknownArray = rt.array(rt.unknown);
const schemaString = exports.schemaString = rt.string;
const schemaStringArray = exports.schemaStringArray = rt.array(schemaString);
const schemaNumber = exports.schemaNumber = rt.number;
const schemaNumberArray = exports.schemaNumberArray = rt.array(schemaNumber);
const schemaDate = exports.schemaDate = rt.union([IsoDateString, schemaNumber]);
const schemaDateArray = exports.schemaDateArray = rt.array(schemaDate);
const schemaDateRange = exports.schemaDateRange = rt.partial({
  gte: schemaDate,
  lte: schemaDate
});
const schemaDateRangeArray = exports.schemaDateRangeArray = rt.array(schemaDateRange);
const schemaStringOrNumber = exports.schemaStringOrNumber = rt.union([schemaString, schemaNumber]);
const schemaStringOrNumberArray = exports.schemaStringOrNumberArray = rt.array(schemaStringOrNumber);
const schemaBoolean = exports.schemaBoolean = rt.boolean;
const schemaBooleanArray = exports.schemaBooleanArray = rt.array(schemaBoolean);
const schemaGeoPointCoords = rt.type({
  type: schemaString,
  coordinates: schemaNumberArray
});
const schemaGeoPointString = schemaString;
const schemaGeoPointLatLon = rt.type({
  lat: schemaNumber,
  lon: schemaNumber
});
const schemaGeoPointLocation = rt.type({
  location: schemaNumberArray
});
const schemaGeoPointLocationString = rt.type({
  location: schemaString
});
const schemaGeoPoint = exports.schemaGeoPoint = rt.union([schemaGeoPointCoords, schemaGeoPointString, schemaGeoPointLatLon, schemaGeoPointLocation, schemaGeoPointLocationString]);
const schemaGeoPointArray = exports.schemaGeoPointArray = rt.array(schemaGeoPoint);
// prettier-ignore
const ObservabilityUptimeAlertRequired = rt.type({});
// prettier-ignore
const ObservabilityUptimeAlertOptional = rt.partial({
  'agent.name': schemaString,
  'anomaly.bucket_span.minutes': schemaString,
  'anomaly.start': schemaDate,
  configId: schemaString,
  'error.message': schemaString,
  'error.stack_trace': schemaString,
  'host.name': schemaString,
  'kibana.alert.context': schemaUnknown,
  'kibana.alert.evaluation.threshold': schemaStringOrNumber,
  'kibana.alert.evaluation.value': schemaStringOrNumber,
  'kibana.alert.evaluation.values': schemaStringOrNumberArray,
  'kibana.alert.group': rt.array(rt.partial({
    field: schemaStringArray,
    value: schemaStringArray
  })),
  labels: schemaUnknown,
  'location.id': schemaStringArray,
  'location.name': schemaStringArray,
  'monitor.id': schemaString,
  'monitor.name': schemaString,
  'monitor.state.id': schemaString,
  'monitor.tags': schemaStringArray,
  'monitor.type': schemaString,
  'observer.geo.name': schemaStringArray,
  'observer.name': schemaStringArray,
  'service.name': schemaString,
  'tls.server.hash.sha256': schemaString,
  'tls.server.x509.issuer.common_name': schemaString,
  'tls.server.x509.not_after': schemaDate,
  'tls.server.x509.not_before': schemaDate,
  'tls.server.x509.subject.common_name': schemaString,
  'url.full': schemaString
});

// prettier-ignore
const ObservabilityUptimeAlertSchema = exports.ObservabilityUptimeAlertSchema = rt.intersection([ObservabilityUptimeAlertRequired, ObservabilityUptimeAlertOptional, _alert_schema.AlertSchema, _legacy_alert_schema.LegacyAlertSchema]);
// prettier-ignore