"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEcsGroups = void 0;
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEcsGroups = (groups = []) => {
  const ecsGroups = groups.filter(group => {
    const path = group.field;
    const ecsField = _alertsAsDataUtils.ecsFieldMap[path];
    if (!Boolean(!!ecsField)) {
      return false;
    }

    // we only allow keyword group values
    if (ecsField.type !== 'keyword') {
      return false;
    }
    return true;
  });
  const ecsGroup = {};
  ecsGroups.forEach(group => {
    ecsGroup[group.field] = group.value;
  });
  return ecsGroup;
};
exports.getEcsGroups = getEcsGroups;