"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialByWeekday = void 0;
var _common = require("../../../../common");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInitialByWeekday = (initialStateByweekday, date) => {
  const dayOfWeek = date ? date.isoWeekday() : 1;
  return _common.ISO_WEEKDAYS.reduce((result, n) => {
    result[n] = (initialStateByweekday === null || initialStateByweekday === void 0 ? void 0 : initialStateByweekday.length) > 0 ? initialStateByweekday
    // Sanitize nth day strings, e.g. +2MO, -1FR, into just days of the week
    .map(w => w.replace(/[0-9+\-]/g, '')).includes(_constants.ISO_WEEKDAYS_TO_RRULE[n]) : n === dayOfWeek;
    return result;
  }, {});
};
exports.getInitialByWeekday = getInitialByWeekday;