"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomRecurringSchedule = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rrule = require("@kbn/rrule");
var _moment = _interopRequireDefault(require("moment"));
var _react2 = require("@emotion/react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _eui = require("@elastic/eui");
var _constants = require("../../constants");
var i18n = _interopRequireWildcard(require("../../translations"));
var _get_initial_by_weekday = require("../../helpers/get_initial_by_weekday");
var _get_weekday_info = require("../../helpers/get_weekday_info");
var _parse_schedule = require("../../helpers/parse_schedule");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UseField = (0, _hook_form_lib.getUseField)({
  component: _components.Field
});
const styles = {
  flexField: (0, _react2.css)`
    .euiFormRow__labelWrapper {
      margin-bottom: unset;
    }
  `
};
const CustomRecurringSchedule = exports.CustomRecurringSchedule = /*#__PURE__*/_react.default.memo(() => {
  const [{
    startDate,
    recurringSchedule
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['startDate', 'recurringSchedule.frequency', 'recurringSchedule.interval', 'recurringSchedule.customFrequency']
  });
  const parsedSchedule = (0, _react.useMemo)(() => {
    return (0, _parse_schedule.parseSchedule)(recurringSchedule);
  }, [recurringSchedule]);
  const frequencyOptions = (0, _react.useMemo)(() => (0, _constants.CREATE_FORM_CUSTOM_FREQUENCY)(parsedSchedule === null || parsedSchedule === void 0 ? void 0 : parsedSchedule.interval), [parsedSchedule === null || parsedSchedule === void 0 ? void 0 : parsedSchedule.interval]);
  const bymonthOptions = (0, _react.useMemo)(() => {
    if (!startDate) return [];
    const date = (0, _moment.default)(startDate);
    const {
      dayOfWeek,
      nthWeekdayOfMonth,
      isLastOfMonth
    } = (0, _get_weekday_info.getWeekdayInfo)(date, 'ddd');
    return [{
      id: 'day',
      label: i18n.CREATE_FORM_CUSTOM_REPEAT_MONTHLY_ON_DAY(date)
    }, {
      id: 'weekday',
      label: i18n.CREATE_FORM_WEEKDAY_SHORT(dayOfWeek)[isLastOfMonth ? 0 : nthWeekdayOfMonth]
    }];
  }, [startDate]);
  const defaultByWeekday = (0, _react.useMemo)(() => (0, _get_initial_by_weekday.getInitialByWeekday)([], (0, _moment.default)(startDate)), [startDate]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (parsedSchedule === null || parsedSchedule === void 0 ? void 0 : parsedSchedule.frequency) !== _rrule.Frequency.DAILY ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "recurringSchedule.interval",
    css: styles.flexField,
    componentProps: {
      'data-test-subj': 'interval-field',
      id: 'interval',
      euiFieldProps: {
        'data-test-subj': 'customRecurringScheduleIntervalInput',
        min: 1,
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
          htmlFor: 'interval'
        }, i18n.CREATE_FORM_INTERVAL_EVERY)
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "recurringSchedule.customFrequency",
    componentProps: {
      'data-test-subj': 'custom-frequency-field',
      euiFieldProps: {
        'data-test-subj': 'customRecurringScheduleFrequencySelect',
        options: frequencyOptions
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })) : null, Number(parsedSchedule === null || parsedSchedule === void 0 ? void 0 : parsedSchedule.customFrequency) === _rrule.Frequency.WEEKLY || (parsedSchedule === null || parsedSchedule === void 0 ? void 0 : parsedSchedule.frequency) === _rrule.Frequency.DAILY ? /*#__PURE__*/_react.default.createElement(UseField, {
    path: "recurringSchedule.byweekday",
    config: {
      type: _hook_form_lib.FIELD_TYPES.MULTI_BUTTON_GROUP,
      label: '',
      validations: [{
        validator: ({
          value
        }) => {
          if (Object.values(value).every(v => v === false)) {
            return {
              message: i18n.CREATE_FORM_BYWEEKDAY_REQUIRED
            };
          }
        }
      }],
      defaultValue: defaultByWeekday
    },
    componentProps: {
      'data-test-subj': 'byweekday-field',
      euiFieldProps: {
        'data-test-subj': 'customRecurringScheduleByWeekdayButtonGroup',
        legend: 'Repeat on weekday',
        options: _constants.WEEKDAY_OPTIONS
      }
    }
  }) : null, Number(parsedSchedule === null || parsedSchedule === void 0 ? void 0 : parsedSchedule.customFrequency) === _rrule.Frequency.MONTHLY ? /*#__PURE__*/_react.default.createElement(UseField, {
    path: "recurringSchedule.bymonth",
    componentProps: {
      'data-test-subj': 'bymonth-field',
      euiFieldProps: {
        legend: 'Repeat on weekday or month day',
        options: bymonthOptions
      }
    }
  }) : null);
});
CustomRecurringSchedule.displayName = 'CustomRecurringSchedule';