"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_navigation = require("../../../hooks/use_navigation");
var _constants = require("../constants");
var _upcoming_events_popover = require("./upcoming_events_popover");
var _common = require("../../../../common");
var _status_filter = require("./status_filter");
var _table_actions_popover = require("./table_actions_popover");
var _use_finish_maintenance_window = require("../../../hooks/use_finish_maintenance_window");
var _use_archive_maintenance_window = require("../../../hooks/use_archive_maintenance_window");
var _use_finish_and_archive_maintenance_window = require("../../../hooks/use_finish_and_archive_maintenance_window");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COLUMNS = [{
  field: 'title',
  name: i18n.NAME,
  truncateText: true
}, {
  field: 'status',
  name: i18n.TABLE_STATUS,
  'data-test-subj': 'maintenance-windows-column-status',
  render: status => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: _constants.STATUS_DISPLAY[status].color
    }, _constants.STATUS_DISPLAY[status].label);
  },
  sortable: ({
    status
  }) => _constants.STATUS_SORT[status]
}, {
  field: 'eventStartTime',
  name: i18n.TABLE_START_TIME,
  dataType: 'date',
  render: (startDate, item) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, (0, _eui.formatDate)(startDate, _common.MAINTENANCE_WINDOW_DATE_FORMAT)), item.events.length > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_upcoming_events_popover.UpcomingEventsPopover, {
      maintenanceWindowFindResponse: item
    })) : null);
  },
  sortable: true
}, {
  field: 'eventEndTime',
  name: i18n.TABLE_END_TIME,
  dataType: 'date',
  render: endDate => (0, _eui.formatDate)(endDate, _common.MAINTENANCE_WINDOW_DATE_FORMAT)
}];
const rowProps = item => ({
  className: item.status,
  'data-test-subj': 'list-item'
});
const MaintenanceWindowsList = exports.MaintenanceWindowsList = /*#__PURE__*/_react.default.memo(({
  isLoading,
  items,
  readOnly,
  refreshData,
  page,
  perPage,
  total,
  onPageChange,
  selectedStatus,
  onStatusChange,
  onSearchChange
}) => {
  const [search, setSearch] = (0, _react.useState)('');
  const {
    navigateToEditMaintenanceWindows
  } = (0, _use_navigation.useEditMaintenanceWindowsNavigation)();
  const onEdit = (0, _react.useCallback)(id => navigateToEditMaintenanceWindows(id), [navigateToEditMaintenanceWindows]);
  const {
    mutate: finishMaintenanceWindow,
    isLoading: isLoadingFinish
  } = (0, _use_finish_maintenance_window.useFinishMaintenanceWindow)();
  const onCancel = (0, _react.useCallback)(id => finishMaintenanceWindow(id, {
    onSuccess: () => refreshData()
  }), [finishMaintenanceWindow, refreshData]);
  const {
    mutate: archiveMaintenanceWindow,
    isLoading: isLoadingArchive
  } = (0, _use_archive_maintenance_window.useArchiveMaintenanceWindow)();
  const onArchive = (0, _react.useCallback)((id, archive) => archiveMaintenanceWindow({
    maintenanceWindowId: id,
    archive
  }, {
    onSuccess: () => refreshData()
  }), [archiveMaintenanceWindow, refreshData]);
  const {
    mutate: finishAndArchiveMaintenanceWindow,
    isLoading: isLoadingFinishAndArchive
  } = (0, _use_finish_and_archive_maintenance_window.useFinishAndArchiveMaintenanceWindow)();
  const onCancelAndArchive = (0, _react.useCallback)(id => finishAndArchiveMaintenanceWindow(id, {
    onSuccess: () => refreshData()
  }), [finishAndArchiveMaintenanceWindow, refreshData]);
  const isMutatingOrLoading = (0, _react.useMemo)(() => {
    return isLoadingFinish || isLoadingArchive || isLoadingFinishAndArchive || isLoading;
  }, [isLoadingFinish, isLoadingArchive, isLoadingFinishAndArchive, isLoading]);
  const actions = (0, _react.useMemo)(() => [{
    name: '',
    render: ({
      status,
      id
    }) => {
      return /*#__PURE__*/_react.default.createElement(_table_actions_popover.TableActionsPopover, {
        id: id,
        isLoading: isMutatingOrLoading,
        status: status,
        onEdit: onEdit,
        onCancel: onCancel,
        onArchive: onArchive,
        onCancelAndArchive: onCancelAndArchive
      });
    }
  }], [isMutatingOrLoading, onArchive, onCancel, onCancelAndArchive, onEdit]);
  const columns = (0, _react.useMemo)(() => readOnly ? COLUMNS : COLUMNS.concat(actions), [actions, readOnly]);
  const onInputChange = (0, _react.useCallback)(e => {
    setSearch(e.target.value);
    if (e.target.value === '') {
      onSearchChange(e.target.value);
    }
  }, [onSearchChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "maintenance-window-search",
    fullWidth: true,
    isClearable: true,
    incremental: false,
    placeholder: i18n.SEARCH_PLACEHOLDER,
    value: search,
    onChange: onInputChange,
    onSearch: onSearchChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_status_filter.StatusFilter, {
    selectedStatus: selectedStatus,
    onChange: onStatusChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "refresh-button",
    iconType: "refresh",
    onClick: refreshData,
    isLoading: isMutatingOrLoading,
    isDisabled: isMutatingOrLoading
  }, i18n.REFRESH))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "maintenance-windows-table",
    itemId: "id",
    loading: isMutatingOrLoading,
    tableCaption: "Maintenance Windows List",
    items: items,
    columns: columns,
    pagination: {
      pageIndex: page - 1,
      pageSize: perPage,
      pageSizeOptions: [10, 25, 50],
      totalItemCount: total
    },
    rowProps: rowProps,
    onChange: onPageChange
  })))));
});
MaintenanceWindowsList.displayName = 'MaintenanceWindowsList';